/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.jaxp.SAXParserImpl;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SAXParserFactoryImpl
extends SAXParserFactory {
    private Hashtable features;
    private Schema grammar;
    private boolean isXIncludeAware;

    public SAXParser newSAXParser() throws ParserConfigurationException {
        SAXParserImpl saxParserImpl;
        try {
            saxParserImpl = new SAXParserImpl(this, this.features);
        }
        catch (SAXException se) {
            throw new ParserConfigurationException(se.getMessage());
        }
        return saxParserImpl;
    }

    private SAXParserImpl newSAXParserImpl() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParserImpl saxParserImpl;
        try {
            saxParserImpl = new SAXParserImpl(this, this.features);
        }
        catch (SAXNotSupportedException e) {
            throw e;
        }
        catch (SAXNotRecognizedException e) {
            throw e;
        }
        catch (SAXException se) {
            throw new ParserConfigurationException(se.getMessage());
        }
        return saxParserImpl;
    }

    public void setFeature(String name, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (this.features == null) {
            this.features = new Hashtable();
        }
        this.features.put(name, value ? Boolean.TRUE : Boolean.FALSE);
        try {
            this.newSAXParserImpl();
        }
        catch (SAXNotSupportedException e) {
            this.features.remove(name);
            throw e;
        }
        catch (SAXNotRecognizedException e) {
            this.features.remove(name);
            throw e;
        }
    }

    public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing") && this.features != null) {
            Boolean ob = (Boolean)this.features.get(name);
            if (ob == null) {
                return false;
            }
            return ob;
        }
        return this.newSAXParserImpl().getXMLReader().getFeature(name);
    }

    public Schema getSchema() {
        return this.grammar;
    }

    public void setSchema(Schema grammar) {
        this.grammar = grammar;
    }

    public boolean isXIncludeAware() {
        return this.isXIncludeAware;
    }

    public void setXIncludeAware(boolean state) {
        this.isXIncludeAware = state;
    }
}

