/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.jaxp.DefaultValidationErrorHandler;
import com.sun.org.apache.xerces.internal.jaxp.JAXPConstants;
import com.sun.org.apache.xerces.internal.parsers.AbstractSAXParser;
import com.sun.org.apache.xerces.internal.parsers.JAXPConfiguration;
import com.sun.org.apache.xerces.internal.util.SAXMessageFormatter;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SAXParserImpl
extends SAXParser
implements JAXPConstants {
    private final JAXPConfiguration parserConfiguration;
    private final AbstractSAXParser xmlReader;
    private String schemaLanguage = null;
    private final Schema grammar;
    private final SecurityManager secureProcessing;
    private boolean isXIncludeAware;
    private boolean enableSecureProcessing = true;
    private Hashtable features;
    private SAXParserFactory spf;
    private Hashtable parserFeatures = new Hashtable();

    public boolean isXIncludeAware() {
        return this.isXIncludeAware;
    }

    SAXParserImpl(SAXParserFactory spfactory, Hashtable factoryfeatures) throws SAXException {
        this.spf = spfactory;
        this.features = factoryfeatures;
        this.secureProcessing = new SecurityManager();
        this.grammar = this.spf.getSchema();
        this.parserConfiguration = new JAXPConfiguration(this.grammar);
        this.xmlReader = new com.sun.org.apache.xerces.internal.parsers.SAXParser(this.parserConfiguration);
        this.init();
    }

    void resetSettings() throws SAXNotSupportedException, SAXNotRecognizedException {
        Enumeration keys = this.parserFeatures.keys();
        while (keys.hasMoreElements()) {
            String propertyId = (String)keys.nextElement();
            Object value = this.parserFeatures.get(propertyId);
            if (value instanceof Boolean) {
                this.xmlReader.setFeature(propertyId, this.parserConfiguration.getFeatureDefaultValue(propertyId));
                continue;
            }
            this.xmlReader.setProperty(propertyId, null);
        }
        this.parserFeatures.clear();
    }

    void init() throws SAXNotSupportedException, SAXNotRecognizedException {
        Object tmpValue;
        this.schemaLanguage = null;
        this.isXIncludeAware = this.spf.isXIncludeAware();
        if (this.features != null && (tmpValue = this.features.get("http://javax.xml.XMLConstants/feature/secure-processing")) != null) {
            this.enableSecureProcessing = (Boolean)tmpValue;
        }
        if (this.enableSecureProcessing) {
            try {
                this.setProperty("http://apache.org/xml/properties/security-manager", this.secureProcessing);
            }
            catch (SAXNotRecognizedException sex) {
                sex.printStackTrace();
            }
            catch (SAXNotSupportedException se) {
                se.printStackTrace();
            }
        }
        this.xmlReader.setFeature("http://apache.org/xml/features/xinclude-aware", this.isXIncludeAware);
        if (this.spf.isValidating()) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature("http://xml.org/sax/features/validation", this.spf.isValidating());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", this.spf.isNamespaceAware());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", !this.spf.isNamespaceAware());
        this.setFeatures(this.features);
    }

    private void setFeatures(Hashtable features) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (features != null) {
            Enumeration e = features.keys();
            while (e.hasMoreElements()) {
                String feature = (String)e.nextElement();
                boolean value = (Boolean)features.get(feature);
                if (feature.equals("http://javax.xml.XMLConstants/feature/secure-processing")) continue;
                this.xmlReader.setFeature(feature, value);
            }
        }
    }

    public Parser getParser() throws SAXException {
        return this.xmlReader;
    }

    public void reset() {
        if (this.xmlReader != null) {
            try {
                this.xmlReader.reset();
                this.resetSettings();
            }
            catch (XNIException ex) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        try {
            return this.xmlReader.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXException x) {
            throw new IllegalStateException(x.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.xmlReader.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXException x) {
            throw new IllegalStateException(x.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.grammar != null && ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name) || "http://java.sun.com/xml/jaxp/properties/schemaSource".equals(name))) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(null, "schema-already-specified", null));
        }
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name)) {
            if ("http://www.w3.org/2001/XMLSchema".equals(value)) {
                if (!this.isValidating()) return;
                this.schemaLanguage = "http://www.w3.org/2001/XMLSchema";
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                this.parserFeatures.put("http://apache.org/xml/features/validation/schema", new Boolean(true));
                this.parserFeatures.put("http://apache.org/xml/features/validation/schema-full-checking", new Boolean(true));
                this.xmlReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                this.parserFeatures.put("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                return;
            } else {
                if (value != null) throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(null, "schema-not-supported", null));
                this.schemaLanguage = null;
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
                this.parserFeatures.put("http://apache.org/xml/features/validation/schema", new Boolean(false));
            }
            return;
        } else if ("http://java.sun.com/xml/jaxp/properties/schemaSource".equals(name)) {
            if (!this.isValidating()) return;
            String val = (String)this.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            if (val == null || !"http://www.w3.org/2001/XMLSchema".equals(val)) throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(null, "jaxp-order-not-supported", new Object[]{"http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://java.sun.com/xml/jaxp/properties/schemaSource"}));
            this.xmlReader.setProperty(name, value);
            this.parserFeatures.put(name, value);
            return;
        } else if (value instanceof Boolean) {
            this.xmlReader.setFeature(name, (Boolean)value);
            this.parserFeatures.put(name, value);
            return;
        } else {
            this.xmlReader.setProperty(name, value);
            if (value == null) {
                this.parserFeatures.remove(name);
                return;
            } else {
                this.parserFeatures.put(name, value);
            }
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name)) {
            return this.schemaLanguage;
        }
        return this.xmlReader.getProperty(name);
    }

    public Schema getSchema() {
        return this.grammar;
    }

    public boolean isSecureProcessing() {
        return this.secureProcessing != null;
    }
}

