/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation;

import com.sun.org.apache.xerces.internal.jaxp.validation.ValidatorHandlerImpl;
import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class ValidatorImpl
extends Validator {
    private final ValidatorHandlerImpl handler;
    private Transformer identityTransformer1 = null;
    private TransformerHandler identityTransformer2 = null;
    private final ErrorHandler errorForwarder = new ErrorHandler(){

        public void warning(SAXParseException exception) throws SAXException {
            ErrorHandler realHandler = ValidatorImpl.this.handler.getErrorHandler();
            if (realHandler != null) {
                realHandler.warning(exception);
            }
        }

        public void error(SAXParseException exception) throws SAXException {
            ErrorHandler realHandler = ValidatorImpl.this.handler.getErrorHandler();
            if (realHandler == null) {
                throw exception;
            }
            realHandler.error(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            ErrorHandler realHandler = ValidatorImpl.this.handler.getErrorHandler();
            if (realHandler == null) {
                throw exception;
            }
            realHandler.fatalError(exception);
        }
    };
    private final EntityResolver resolutionForwarder = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            LSResourceResolver resolver = ValidatorImpl.this.handler.getResourceResolver();
            if (resolver == null) {
                return null;
            }
            LSInput di = resolver.resolveResource(null, null, publicId, systemId, null);
            if (di == null) {
                return null;
            }
            InputSource r = new InputSource();
            r.setByteStream(di.getByteStream());
            r.setCharacterStream(di.getCharacterStream());
            r.setEncoding(di.getEncoding());
            r.setPublicId(di.getPublicId());
            r.setSystemId(di.getSystemId());
            return r;
        }
    };

    ValidatorImpl(ValidatorHandlerImpl _handler) {
        this.handler = _handler;
    }

    public LSResourceResolver getResourceResolver() {
        return this.handler.getResourceResolver();
    }

    public ErrorHandler getErrorHandler() {
        return this.handler.getErrorHandler();
    }

    public void setResourceResolver(LSResourceResolver resolver) {
        this.handler.setResourceResolver(resolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.handler.setErrorHandler(errorHandler);
    }

    public void validate(Source source, Result result) throws SAXException, IOException {
        if (source instanceof DOMSource) {
            if (result != null && !(result instanceof DOMResult)) {
                throw new IllegalArgumentException(result.getClass().getName());
            }
            this.process((DOMSource)source, (DOMResult)result);
            return;
        }
        if (source instanceof SAXSource) {
            if (result != null && !(result instanceof SAXResult)) {
                throw new IllegalArgumentException(result.getClass().getName());
            }
            this.process((SAXSource)source, (SAXResult)result);
            return;
        }
        if (source instanceof StreamSource) {
            if (result != null) {
                throw new IllegalArgumentException(result.getClass().getName());
            }
            StreamSource ss = (StreamSource)source;
            InputSource is = new InputSource();
            is.setByteStream(ss.getInputStream());
            is.setCharacterStream(ss.getReader());
            is.setPublicId(ss.getPublicId());
            is.setSystemId(ss.getSystemId());
            this.process(new SAXSource(is), null);
            return;
        }
        throw new IllegalArgumentException(source.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(SAXSource source, SAXResult result) throws IOException, SAXException {
        if (result != null) {
            this.handler.setContentHandler(result.getHandler());
        }
        try {
            XMLReader reader = source.getXMLReader();
            if (reader == null) {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                try {
                    reader = spf.newSAXParser().getXMLReader();
                }
                catch (Exception e) {
                    throw new FactoryConfigurationError(e);
                }
            }
            reader.setErrorHandler(this.errorForwarder);
            reader.setEntityResolver(this.resolutionForwarder);
            reader.setContentHandler(this.handler);
            InputSource is = source.getInputSource();
            reader.parse(is);
        }
        finally {
            this.handler.setContentHandler(null);
        }
    }

    private void process(DOMSource source, DOMResult result) throws SAXException {
        if (this.identityTransformer1 == null) {
            try {
                SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                this.identityTransformer1 = tf.newTransformer();
                this.identityTransformer2 = tf.newTransformerHandler();
            }
            catch (TransformerConfigurationException e) {
                throw new TransformerFactoryConfigurationError(e);
            }
        }
        if (result != null) {
            this.handler.setContentHandler(this.identityTransformer2);
            this.identityTransformer2.setResult(result);
        }
        try {
            this.identityTransformer1.transform(source, new SAXResult(this.handler));
        }
        catch (TransformerException e) {
            if (e.getException() instanceof SAXException) {
                throw (SAXException)e.getException();
            }
            throw new SAXException(e);
        }
        finally {
            this.handler.setContentHandler(null);
        }
    }

    public void reset() {
        this.handler.reset();
        if (this.identityTransformer1 != null) {
            this.identityTransformer1.reset();
        }
    }
}

