/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.dom.AttrImpl;
import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import com.sun.org.apache.xerces.internal.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtil {
    protected DOMUtil() {
    }

    public static void copyInto(Node src, Node dest) throws DOMException {
        Document factory = dest.getOwnerDocument();
        boolean domimpl = factory instanceof DocumentImpl;
        Node start = src;
        Node parent = src;
        Node place = src;
        while (place != null) {
            Node node = null;
            short type = place.getNodeType();
            switch (type) {
                case 4: {
                    node = factory.createCDATASection(place.getNodeValue());
                    break;
                }
                case 8: {
                    node = factory.createComment(place.getNodeValue());
                    break;
                }
                case 1: {
                    Element element = factory.createElement(place.getNodeName());
                    node = element;
                    NamedNodeMap attrs = place.getAttributes();
                    int attrCount = attrs.getLength();
                    for (int i = 0; i < attrCount; ++i) {
                        Attr attr = (Attr)attrs.item(i);
                        String attrName = attr.getNodeName();
                        String attrValue = attr.getNodeValue();
                        element.setAttribute(attrName, attrValue);
                        if (!domimpl || attr.getSpecified()) continue;
                        ((AttrImpl)element.getAttributeNode(attrName)).setSpecified(false);
                    }
                    break;
                }
                case 5: {
                    node = factory.createEntityReference(place.getNodeName());
                    break;
                }
                case 7: {
                    node = factory.createProcessingInstruction(place.getNodeName(), place.getNodeValue());
                    break;
                }
                case 3: {
                    node = factory.createTextNode(place.getNodeValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("can't copy node type, " + type + " (" + node.getNodeName() + ')');
                }
            }
            dest.appendChild(node);
            if (place.hasChildNodes()) {
                parent = place;
                place = place.getFirstChild();
                dest = node;
                continue;
            }
            place = place.getNextSibling();
            while (place == null && parent != start) {
                place = parent.getNextSibling();
                parent = parent.getParentNode();
                dest = dest.getParentNode();
            }
        }
    }

    public static Element getFirstChildElement(Node parent) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getFirstVisibleChildElement(Node parent) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || DOMUtil.isHidden(child)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getLastChildElement(Node parent) {
        for (Node child = parent.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getLastVisibleChildElement(Node parent) {
        for (Node child = parent.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1 || DOMUtil.isHidden(child)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node) {
        for (Node sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return (Element)sibling;
        }
        return null;
    }

    public static Element getNextVisibleSiblingElement(Node node) {
        for (Node sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1 || DOMUtil.isHidden(sibling)) continue;
            return (Element)sibling;
        }
        return null;
    }

    public static void setHidden(Node node) {
        if (node instanceof com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl) {
            ((com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl)node).setReadOnly(true, false);
        } else if (node instanceof NodeImpl) {
            ((NodeImpl)node).setReadOnly(true, false);
        }
    }

    public static void setVisible(Node node) {
        if (node instanceof com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl) {
            ((com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl)node).setReadOnly(false, false);
        } else if (node instanceof NodeImpl) {
            ((NodeImpl)node).setReadOnly(false, false);
        }
    }

    public static boolean isHidden(Node node) {
        if (node instanceof com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl) {
            return ((com.sun.org.apache.xerces.internal.impl.xs.opti.NodeImpl)node).getReadOnly();
        }
        if (node instanceof NodeImpl) {
            return ((NodeImpl)node).getReadOnly();
        }
        return false;
    }

    public static Element getFirstChildElement(Node parent, String elemName) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals(elemName)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getLastChildElement(Node parent, String elemName) {
        for (Node child = parent.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals(elemName)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node, String elemName) {
        for (Node sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1 || !sibling.getNodeName().equals(elemName)) continue;
            return (Element)sibling;
        }
        return null;
    }

    public static Element getFirstChildElementNS(Node parent, String uri, String localpart) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            String childURI;
            if (child.getNodeType() != 1 || (childURI = child.getNamespaceURI()) == null || !childURI.equals(uri) || !child.getLocalName().equals(localpart)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getLastChildElementNS(Node parent, String uri, String localpart) {
        for (Node child = parent.getLastChild(); child != null; child = child.getPreviousSibling()) {
            String childURI;
            if (child.getNodeType() != 1 || (childURI = child.getNamespaceURI()) == null || !childURI.equals(uri) || !child.getLocalName().equals(localpart)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElementNS(Node node, String uri, String localpart) {
        for (Node sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            String siblingURI;
            if (sibling.getNodeType() != 1 || (siblingURI = sibling.getNamespaceURI()) == null || !siblingURI.equals(uri) || !sibling.getLocalName().equals(localpart)) continue;
            return (Element)sibling;
        }
        return null;
    }

    public static Element getFirstChildElement(Node parent, String[] elemNames) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            for (int i = 0; i < elemNames.length; ++i) {
                if (!child.getNodeName().equals(elemNames[i])) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static Element getLastChildElement(Node parent, String[] elemNames) {
        for (Node child = parent.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1) continue;
            for (int i = 0; i < elemNames.length; ++i) {
                if (!child.getNodeName().equals(elemNames[i])) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node, String[] elemNames) {
        for (Node sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            for (int i = 0; i < elemNames.length; ++i) {
                if (!sibling.getNodeName().equals(elemNames[i])) continue;
                return (Element)sibling;
            }
        }
        return null;
    }

    public static Element getFirstChildElementNS(Node parent, String[][] elemNames) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            for (int i = 0; i < elemNames.length; ++i) {
                String uri = child.getNamespaceURI();
                if (uri == null || !uri.equals(elemNames[i][0]) || !child.getLocalName().equals(elemNames[i][1])) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static Element getLastChildElementNS(Node parent, String[][] elemNames) {
        for (Node child = parent.getLastChild(); child != null; child = child.getPreviousSibling()) {
            if (child.getNodeType() != 1) continue;
            for (int i = 0; i < elemNames.length; ++i) {
                String uri = child.getNamespaceURI();
                if (uri == null || !uri.equals(elemNames[i][0]) || !child.getLocalName().equals(elemNames[i][1])) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static Element getNextSiblingElementNS(Node node, String[][] elemNames) {
        for (Node sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            for (int i = 0; i < elemNames.length; ++i) {
                String uri = sibling.getNamespaceURI();
                if (uri == null || !uri.equals(elemNames[i][0]) || !sibling.getLocalName().equals(elemNames[i][1])) continue;
                return (Element)sibling;
            }
        }
        return null;
    }

    public static Element getFirstChildElement(Node parent, String elemName, String attrName, String attrValue) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element element;
            if (child.getNodeType() != 1 || !(element = (Element)child).getNodeName().equals(elemName) || !element.getAttribute(attrName).equals(attrValue)) continue;
            return element;
        }
        return null;
    }

    public static Element getLastChildElement(Node parent, String elemName, String attrName, String attrValue) {
        for (Node child = parent.getLastChild(); child != null; child = child.getPreviousSibling()) {
            Element element;
            if (child.getNodeType() != 1 || !(element = (Element)child).getNodeName().equals(elemName) || !element.getAttribute(attrName).equals(attrValue)) continue;
            return element;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node, String elemName, String attrName, String attrValue) {
        for (Node sibling = node.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            Element element;
            if (sibling.getNodeType() != 1 || !(element = (Element)sibling).getNodeName().equals(elemName) || !element.getAttribute(attrName).equals(attrValue)) continue;
            return element;
        }
        return null;
    }

    public static String getChildText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type == 3) {
                str.append(child.getNodeValue());
                continue;
            }
            if (type != 4) continue;
            str.append(DOMUtil.getChildText(child));
        }
        return str.toString();
    }

    public static String getName(Node node) {
        return node.getNodeName();
    }

    public static String getLocalName(Node node) {
        String name = node.getLocalName();
        return name != null ? name : node.getNodeName();
    }

    public static Element getParent(Element elem) {
        Node parent = elem.getParentNode();
        if (parent instanceof Element) {
            return (Element)parent;
        }
        return null;
    }

    public static Document getDocument(Node node) {
        return node.getOwnerDocument();
    }

    public static Element getRoot(Document doc) {
        return doc.getDocumentElement();
    }

    public static Attr getAttr(Element elem, String name) {
        return elem.getAttributeNode(name);
    }

    public static Attr getAttrNS(Element elem, String nsUri, String localName) {
        return elem.getAttributeNodeNS(nsUri, localName);
    }

    public static Attr[] getAttrs(Element elem) {
        NamedNodeMap attrMap = elem.getAttributes();
        Attr[] attrArray = new Attr[attrMap.getLength()];
        for (int i = 0; i < attrMap.getLength(); ++i) {
            attrArray[i] = (Attr)attrMap.item(i);
        }
        return attrArray;
    }

    public static String getValue(Attr attribute) {
        return attribute.getValue();
    }

    public static String getAttrValue(Element elem, String name) {
        return elem.getAttribute(name);
    }

    public static String getAttrValueNS(Element elem, String nsUri, String localName) {
        return elem.getAttributeNS(nsUri, localName);
    }

    public static String getNamespaceURI(Node node) {
        return node.getNamespaceURI();
    }
}

