/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.xinclude;

import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.io.ASCIIReader;
import com.sun.org.apache.xerces.internal.impl.io.UTF8Reader;
import com.sun.org.apache.xerces.internal.util.EncodingMap;
import com.sun.org.apache.xerces.internal.util.MessageFormatter;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLStringBuffer;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;

public class XIncludeTextReader {
    private Reader fReader;
    private XIncludeHandler fHandler;
    private XMLInputSource fSource;
    private XMLErrorReporter fErrorReporter;
    private String fAccept;
    private String fAcceptLanguage;

    public XIncludeTextReader(XMLInputSource source, XIncludeHandler handler) throws IOException {
        this.fHandler = handler;
        this.fSource = source;
    }

    public void setErrorReporter(XMLErrorReporter errorReporter) {
        this.fErrorReporter = errorReporter;
    }

    public void setHttpProperties(String accept, String acceptLanguage) {
        this.fAccept = accept;
        this.fAcceptLanguage = acceptLanguage;
    }

    protected Reader getReader(XMLInputSource source) throws IOException {
        if (source.getCharacterStream() != null) {
            return source.getCharacterStream();
        }
        InputStream stream = null;
        String encoding = source.getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (source.getByteStream() != null) {
            stream = source.getByteStream();
            if (!(stream instanceof BufferedInputStream)) {
                stream = new BufferedInputStream(stream);
            }
        } else {
            String expandedSystemId = XMLEntityManager.expandSystemId(source.getSystemId(), source.getBaseSystemId(), false);
            URL url = new URL(expandedSystemId);
            URLConnection urlCon = url.openConnection();
            if (urlCon instanceof HttpURLConnection) {
                if (this.fAccept != null && this.fAccept.length() > 0) {
                    urlCon.setRequestProperty("Accept", this.fAccept);
                }
                if (this.fAcceptLanguage != null && this.fAcceptLanguage.length() > 0) {
                    urlCon.setRequestProperty("Accept-Language", this.fAcceptLanguage);
                }
            }
            stream = new BufferedInputStream(urlCon.getInputStream());
            String rawContentType = urlCon.getContentType();
            int index = rawContentType != null ? rawContentType.indexOf(59) : -1;
            String contentType = null;
            String charset = null;
            if (index != -1) {
                contentType = rawContentType.substring(0, index).trim();
                charset = rawContentType.substring(index + 1).trim();
                if (charset.startsWith("charset=")) {
                    if ((charset = charset.substring(8).trim()).charAt(0) == '\"' && charset.charAt(charset.length() - 1) == '\"' || charset.charAt(0) == '\'' && charset.charAt(charset.length() - 1) == '\'') {
                        charset = charset.substring(1, charset.length() - 1);
                    }
                } else {
                    charset = null;
                }
            } else {
                contentType = rawContentType.trim();
            }
            String detectedEncoding = null;
            if (contentType.equals("text/xml")) {
                detectedEncoding = charset != null ? charset : "US-ASCII";
            } else if (contentType.equals("application/xml")) {
                detectedEncoding = charset != null ? charset : this.getEncodingName(stream);
            } else if (contentType.endsWith("+xml")) {
                detectedEncoding = this.getEncodingName(stream);
            }
            if (detectedEncoding != null) {
                encoding = detectedEncoding;
            }
        }
        encoding = encoding.toUpperCase(Locale.ENGLISH);
        this.consumeBOM(stream, encoding);
        if (encoding.equals("UTF-8")) {
            return new UTF8Reader(stream, 2048, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        String javaEncoding = EncodingMap.getIANA2JavaMapping(encoding);
        if (javaEncoding == null) {
            MessageFormatter aFormatter = this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210");
            Locale aLocale = this.fErrorReporter.getLocale();
            throw new IOException(aFormatter.formatMessage(aLocale, "EncodingDeclInvalid", new Object[]{encoding}));
        }
        if (javaEncoding.equals("ASCII")) {
            return new ASCIIReader(stream, 2048, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
        }
        return new InputStreamReader(stream, javaEncoding);
    }

    protected String getEncodingName(InputStream stream) throws IOException {
        byte[] b4 = new byte[4];
        String encoding = null;
        stream.mark(4);
        int count = stream.read(b4, 0, 4);
        stream.reset();
        if (count == 4) {
            encoding = this.getEncodingName(b4);
        }
        return encoding;
    }

    protected void consumeBOM(InputStream stream, String encoding) throws IOException {
        byte[] b = new byte[3];
        int count = 0;
        stream.mark(3);
        if (encoding.equals("UTF-8")) {
            count = stream.read(b, 0, 3);
            if (count == 3) {
                int b0 = b[0] & 0xFF;
                int b1 = b[1] & 0xFF;
                int b2 = b[2] & 0xFF;
                if (b0 != 239 || b1 != 187 || b2 != 191) {
                    stream.reset();
                }
            } else {
                stream.reset();
            }
        } else if (encoding.startsWith("UTF-16")) {
            count = stream.read(b, 0, 2);
            if (count == 2) {
                int b0 = b[0] & 0xFF;
                int b1 = b[1] & 0xFF;
                if (!(b0 == 254 && b1 == 255 || b0 == 255 && b1 == 254)) {
                    stream.reset();
                }
            } else {
                stream.reset();
            }
        }
    }

    protected String getEncodingName(byte[] b4) {
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return "UTF-16BE";
        }
        if (b0 == 255 && b1 == 254) {
            return "UTF-16LE";
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return "UTF-8";
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return "UTF-16BE";
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return "UTF-16LE";
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return "CP037";
        }
        return null;
    }

    public void parse() throws IOException {
        int ch;
        XMLStringBuffer buffer = new XMLStringBuffer();
        this.fReader = this.getReader(this.fSource);
        while ((ch = this.fReader.read()) != -1) {
            if (this.isValid(ch)) {
                buffer.append((char)ch);
                continue;
            }
            if (XMLChar.isHighSurrogate(ch)) {
                int ch2 = this.fReader.read();
                if (XMLChar.isLowSurrogate(ch2)) {
                    int sup = XMLChar.supplemental((char)ch, (char)ch2);
                    if (!this.isValid(sup)) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(sup, 16)}, (short)2);
                        continue;
                    }
                    buffer.append((char)ch);
                    buffer.append((char)ch2);
                    continue;
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(ch, 16)}, (short)2);
                continue;
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(ch, 16)}, (short)2);
        }
        if (this.fHandler != null && buffer.length > 0) {
            this.fHandler.characters(buffer, this.fHandler.modifyAugmentations(null, true));
        }
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
        }
    }

    protected boolean isValid(int ch) {
        return XMLChar.isValid(ch);
    }
}

