/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.control;

import java.io.Serializable;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class WeightedSwitchController
extends GenericController
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String WEIGHTS = "Weights";
    private boolean chosen = false;
    protected long[] counts = null;
    protected long totalCount = 0L;

    public void setData(PowerTableModel model) {
        CollectionProperty prop = JMeterPluginsUtils.tableModelRowsToCollectionProperty(model, WEIGHTS);
        this.setProperty((JMeterProperty)prop);
    }

    public CollectionProperty getData() {
        JMeterProperty prop = this.getProperty(WEIGHTS);
        if (prop instanceof CollectionProperty) {
            return (CollectionProperty)prop;
        }
        log.warn("Returning empty collection");
        return new CollectionProperty();
    }

    public Sampler next() {
        if (this.chosen) {
            this.chosen = false;
            return null;
        }
        this.chosen = true;
        this.choose();
        return super.next();
    }

    private void choose() {
        int n;
        CollectionProperty data = this.getData();
        if (this.counts == null) {
            log.debug("Creating array: " + data.size());
            this.counts = new long[data.size()];
        }
        double[] weights = this.getWeights(data);
        double maxDiff = Double.MIN_VALUE;
        int maxDiffIndex = Integer.MIN_VALUE;
        for (n = 0; n < weights.length; ++n) {
            double factWeight = this.totalCount > 0L ? (double)this.counts[n] / (double)this.totalCount : 0.0;
            double diff = weights[n] - factWeight;
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
            maxDiffIndex = n;
        }
        if (maxDiffIndex == Integer.MIN_VALUE) {
            for (n = 0; n < weights.length; ++n) {
                double diff = weights[n];
                if (!(diff > maxDiff)) continue;
                maxDiff = diff;
                maxDiffIndex = n;
            }
        }
        ++this.totalCount;
        int n2 = maxDiffIndex;
        this.counts[n2] = this.counts[n2] + 1L;
        this.current = maxDiffIndex;
    }

    private double[] getWeights(CollectionProperty data) {
        int n;
        long sum = 0L;
        double[] weights = new double[data.size()];
        for (n = 0; n < data.size(); ++n) {
            CollectionProperty row = (CollectionProperty)data.get(n);
            weights[n] = Long.parseLong(row.get(1).getStringValue());
            sum = (long)((double)sum + weights[n]);
        }
        n = 0;
        while (n < weights.length) {
            int n2 = n++;
            weights[n2] = weights[n2] / (double)sum;
        }
        return weights;
    }
}

