/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.cmdtools;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ListIterator;
import kg.apc.cmd.UniversalRunner;
import kg.apc.cmdtools.AbstractCMDTool;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.timers.Timer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.log.Priority;

public class TestPlanCheckTool
extends AbstractCMDTool {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String jmx = null;
    private boolean isStats = false;
    private boolean isDump = false;

    public TestPlanCheckTool() {
        JMeterPluginsUtils.prepareJMeterEnv(UniversalRunner.getJARLocation());
    }

    protected void showHelp(PrintStream os) {
        os.println("Options for tool 'TestPlanCheck': --jmx <filename> [ --stats --tree-dump ]");
    }

    protected int processParams(ListIterator args) throws UnsupportedOperationException, IllegalArgumentException {
        String nextArg;
        LoggingManager.setPriority((Priority)Priority.INFO);
        while (args.hasNext()) {
            nextArg = (String)args.next();
            if (!nextArg.equals("--loglevel")) continue;
            args.remove();
            String loglevelStr = (String)args.next();
            args.remove();
            LoggingManager.setPriority((String)loglevelStr);
        }
        while (args.hasPrevious()) {
            args.previous();
        }
        while (args.hasNext()) {
            nextArg = (String)args.next();
            log.debug("Arg: " + nextArg);
            if (nextArg.equalsIgnoreCase("--jmx")) {
                if (!args.hasNext()) {
                    throw new IllegalArgumentException("Missing JMX file name");
                }
                this.jmx = (String)args.next();
                continue;
            }
            if (nextArg.equalsIgnoreCase("--stats")) {
                this.isStats = true;
                continue;
            }
            if (nextArg.equalsIgnoreCase("--tree-dump")) {
                this.isDump = true;
                continue;
            }
            throw new IllegalArgumentException("Unknown option: " + nextArg);
        }
        if (this.jmx == null) {
            throw new IllegalArgumentException("Cannot proceed without --jmx option");
        }
        return this.doJob();
    }

    private int doJob() {
        HashTree testTree;
        try {
            testTree = this.loadJMX(new FileInputStream(new File(this.jmx)));
            log.info("JMX is fine");
        }
        catch (Exception e) {
            log.error("Failed to load JMX", (Throwable)e);
            return 1;
        }
        if (this.isStats) {
            this.showStats(testTree);
        }
        if (this.isDump) {
            this.dumpTree(testTree);
        }
        return 0;
    }

    private void dumpTree(HashTree testTree) {
        log.info("Dumping tree structure:");
        testTree.traverse((HashTreeTraverser)new TreeDumper());
    }

    private void showStats(HashTree testTree) {
        log.info("Element stats goes below:");
        StatsCollector stats = new StatsCollector();
        testTree.traverse((HashTreeTraverser)stats);
        stats.logStats();
    }

    private HashTree loadJMX(InputStream reader) throws Exception {
        HashTree tree = SaveService.loadTree((InputStream)reader);
        if (tree == null) {
            throw new TestPlanBrokenException("There was problems loading test plan. Please investigate error messages above.");
        }
        JMeter.convertSubTree((HashTree)tree);
        StandardJMeterEngine engine = new StandardJMeterEngine();
        engine.configure(tree);
        return tree;
    }

    private class StatsCollector
    implements HashTreeTraverser {
        private int tGroups = 0;
        private int controllers = 0;
        private int samplers = 0;
        private int listeners = 0;
        private int others = 0;
        private int preProc = 0;
        private int postProc = 0;
        private int assertions = 0;
        private int timers = 0;
        private int configs = 0;

        private StatsCollector() {
        }

        public void addNode(Object node, HashTree subTree) {
            if (node instanceof AbstractThreadGroup) {
                ++this.tGroups;
            } else if (node instanceof Controller) {
                ++this.controllers;
            } else if (node instanceof Sampler) {
                ++this.samplers;
            } else if (node instanceof AbstractListenerElement) {
                ++this.listeners;
            } else if (node instanceof PreProcessor) {
                ++this.preProc;
            } else if (node instanceof PostProcessor) {
                ++this.postProc;
            } else if (node instanceof Assertion) {
                ++this.assertions;
            } else if (node instanceof Timer) {
                ++this.timers;
            } else if (node instanceof ConfigElement) {
                ++this.configs;
            } else if (node instanceof TestPlan) {
                log.debug("Ok, we got the root of test plan");
            } else if (node instanceof WorkBench) {
                log.debug("Ok, we got the root of test plan");
            } else {
                log.warn("Strange object in tree: " + node);
                ++this.others;
            }
        }

        public void subtractNode() {
        }

        public void processPath() {
        }

        public void logStats() {
            log.info("Thread Groups:\t" + this.tGroups);
            log.info("Controllers:\t" + this.controllers);
            log.info("Config Items:\t" + this.configs);
            log.info("Samplers:\t" + this.samplers);
            log.info("Listeners:\t" + this.listeners);
            log.info("Timers:\t" + this.timers);
            log.info("Assertions:\t" + this.assertions);
            log.info("Pre-Processors:\t" + this.preProc);
            log.info("Post-Processors:\t" + this.postProc);
            if (this.others > 0) {
                log.info("Unknown Elements:\t" + this.others);
            }
        }
    }

    private class TreeDumper
    implements HashTreeTraverser {
        private int indent = 0;

        private TreeDumper() {
        }

        public void addNode(Object o, HashTree hashTree) {
            if (o instanceof TestElement) {
                TestElement el = (TestElement)o;
                log.info(StringUtils.repeat(" ", this.indent) + "[" + el.getClass().getSimpleName() + "] " + el.getName());
            } else {
                log.info(StringUtils.repeat(" ", this.indent) + o);
            }
            ++this.indent;
        }

        public void subtractNode() {
            --this.indent;
        }

        public void processPath() {
        }
    }

    public class TestPlanBrokenException
    extends RuntimeException {
        public TestPlanBrokenException(String s) {
            super(s);
        }
    }
}

