/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import java.util.Arrays;
import kg.apc.perfmon.metrics.AbstractCPUMetric;
import kg.apc.perfmon.metrics.MetricParamsSigar;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

class CPUProcMetric
extends AbstractCPUMetric {
    public static final byte PERCENT = 0;
    public static final byte TOTAL = 1;
    public static final byte SYSTEM = 2;
    public static final byte USER = 3;
    public static final String[] types = new String[]{"percent", "total", "system", "user"};
    private int type = -1;
    private double prev = -1.0;

    protected CPUProcMetric(SigarProxy aSigar, MetricParamsSigar params) {
        super(aSigar, params);
        if (params.type.length() == 0) {
            this.type = 0;
        } else {
            this.type = Arrays.asList(types).indexOf(params.type);
            if (this.type < 0) {
                throw new IllegalArgumentException("Invalid process cpu type: " + params.type);
            }
        }
    }

    public void getValue(StringBuffer res) throws SigarException {
        double val;
        ProcCpu cpu = this.sigarProxy.getProcCpu(this.params.PID);
        switch (this.type) {
            case 0: {
                val = 100.0 * cpu.getPercent();
                break;
            }
            case 1: {
                long cur = cpu.getTotal();
                val = this.prev > 0.0 ? (double)cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 2: {
                long cur = cpu.getSys();
                val = this.prev > 0.0 ? (double)cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 3: {
                long cur = cpu.getUser();
                val = this.prev > 0.0 ? (double)cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            default: {
                throw new SigarException("Unknown proc cpu type " + this.type);
            }
        }
        res.append(Double.toString(val));
    }
}

