/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMXConnectorHelper {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public MBeanServerConnection getServerConnection(String url, String user, String pwd) {
        try {
            JMXConnector connector = this.getJMXConnector(url, user, pwd);
            return connector.getMBeanServerConnection();
        }
        catch (Exception ex) {
            log.error("Failed to get JMX Connector", (Throwable)ex);
            throw new RuntimeException("Failed to get JMX Connector", ex);
        }
    }

    private JMXConnector getJMXConnector(String url, String usr, String pwd) throws MalformedURLException, IOException {
        String serviceUrl = "service:jmx:rmi:///jndi/rmi://" + url + "/jmxrmi";
        if (usr == null || usr.trim().length() <= 0 || pwd == null || pwd.trim().length() <= 0) {
            JMXServiceURL surl = new JMXServiceURL(serviceUrl);
            return JMXConnectorFactory.connect(surl);
        }
        HashMap<String, Object> envMap = new HashMap<String, Object>();
        envMap.put("jmx.remote.credentials", new String[]{usr, pwd});
        envMap.put("java.naming.security.principal", usr);
        envMap.put("java.naming.security.credentials", pwd);
        return JMXConnectorFactory.connect(new JMXServiceURL(serviceUrl), envMap);
    }
}

