/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.tools;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.jmeterplugins.save.MergeResultsService;

public class FilterResults
extends AbstractGraphPanelVisualizer {
    private static final long serialVersionUID = 6432873068917332588L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private Collection<String> emptyCollection = new ArrayList<String>();
    private List<SampleResult> samples = new ArrayList<SampleResult>();

    public FilterResults() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.makeTitlePanel());
    }

    public Collection<String> getMenuCategories() {
        return this.emptyCollection;
    }

    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        res.setSaveConfig(this.collector.getSaveConfig());
        this.samples.add(res);
    }

    public CorrectedResultCollector getCollector() {
        return (CorrectedResultCollector)this.createTestElement();
    }

    public int doJob(CorrectedResultCollector collector, String outputFile) {
        log.info("Setup filtering...");
        this.setUpFiltering(collector);
        log.info("Loading file...");
        collector.loadExistingFile();
        if (!this.samples.isEmpty()) {
            log.info("Merging results to " + outputFile);
            collector.setProperty("filename", outputFile);
            MergeResultsService mrs = new MergeResultsService();
            mrs.mergeSamples(collector, this.samples);
            this.samples.clear();
        }
        return 0;
    }

    @Override
    public String getWikiPage() {
        return "FilterResults";
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 0);
    }

    @Override
    public String getStaticLabel() {
        return "Nobody never should not see this. No, no, no.";
    }
}

