/*
 * Decompiled with CFR 0.152.
 */
package me.geso.tinyvalidator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConstraintViolation {
    private final Object value;
    private final Annotation annotation;
    private final String name;
    private static final Pattern pattern = Pattern.compile("\\{([^}]+)\\}");

    ConstraintViolation(Object value, Annotation annotation, String name) {
        this.value = value;
        this.annotation = annotation;
        this.name = name;
    }

    public String getMessage() {
        Method method = this.annotation.getClass().getMethod("message", new Class[0]);
        String messageTemplate = (String)method.invoke((Object)this.annotation, new Object[0]);
        StringBuffer resultString = new StringBuffer();
        Matcher matcher = pattern.matcher(messageTemplate);
        while (matcher.find()) {
            MatchResult matchResult = matcher.toMatchResult();
            String methodName = matchResult.group(1);
            String value = this.annotation.getClass().getMethod(methodName, new Class[0]).invoke((Object)this.annotation, new Object[0]).toString();
            matcher.appendReplacement(resultString, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(resultString);
        return resultString.toString();
    }

    public Object getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ConstraintViolation(value=" + this.getValue() + ", annotation=" + this.annotation + ", name=" + this.getName() + ")";
    }
}

