/*
 * Decompiled with CFR 0.152.
 */
package me.geso.tinyvalidator;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.geso.tinyvalidator.Valid;
import me.geso.tinyvalidator.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyAccessor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyAccessor.class);
    private final Method readMethod;
    private final PropertyDescriptor descriptor;
    private final List<Annotation> annotations;
    private final Optional<NotNull> notNullAnnotation;
    private final Optional<Valid> validAnnotation;

    PropertyAccessor(Object bean, PropertyDescriptor descriptor) {
        this.readMethod = descriptor.getReadMethod();
        this.readMethod.setAccessible(true);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        try {
            Field field = bean.getClass().getDeclaredField(descriptor.getName());
            if (field != null) {
                Annotation[] annotationArray = field.getAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation annotation = annotationArray[i];
                    annotations.add(annotation);
                }
            }
        }
        catch (NoSuchFieldException e) {
            logger.debug("{} doesn't have {} field: {}", new Object[]{bean.getClass(), descriptor.getName(), e.getMessage()});
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        for (Annotation annotation : this.readMethod.getAnnotations()) {
            annotations.add(annotation);
        }
        this.annotations = Collections.unmodifiableList(annotations);
        this.notNullAnnotation = this.buildNotNullAnnotation(annotations);
        this.validAnnotation = PropertyAccessor.findValidAnnotations(annotations);
        this.descriptor = descriptor;
    }

    private Optional<NotNull> buildNotNullAnnotation(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof NotNull)) continue;
            return Optional.of((NotNull)annotation);
        }
        return Optional.empty();
    }

    private static Optional<Valid> findValidAnnotations(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Valid)) continue;
            return Optional.of((Valid)annotation);
        }
        return Optional.empty();
    }

    List<Annotation> getAnnotations() {
        return this.annotations;
    }

    Object get(Object object) {
        try {
            return this.readMethod.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    String getName() {
        return this.descriptor.getName();
    }

    Optional<NotNull> getNotNullAnnotation() {
        return this.notNullAnnotation;
    }

    Optional<Valid> getValidAnnotation() {
        return this.validAnnotation;
    }
}

