/*
 * Decompiled with CFR 0.152.
 */
package me.geso.tinyvalidator;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.geso.tinyvalidator.Constraint;
import me.geso.tinyvalidator.ConstraintValidator;
import me.geso.tinyvalidator.ConstraintViolation;
import me.geso.tinyvalidator.Node;
import me.geso.tinyvalidator.PropertyAccessor;
import me.geso.tinyvalidator.ValidationContext;
import me.geso.tinyvalidator.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private static Logger logger = LoggerFactory.getLogger(Validator.class);
    private static Map<Class<?>, PropertyAccessor[]> accessorCache = new ConcurrentHashMap();

    public <T> List<ConstraintViolation> validate(T bean) {
        ValidationContext context = new ValidationContext();
        Node node = new Node();
        this.doValidate(bean, context, node);
        return context.getViolations();
    }

    private <T> void doValidate(Object value, ValidationContext context, Node node) {
        PropertyAccessor[] accessors;
        if (logger.isDebugEnabled()) {
            logger.debug("Checking {}", value.getClass());
        }
        if (value.getClass().isPrimitive()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} is a primitive type.", value.getClass());
            }
            return;
        }
        context.registerSeen(value);
        for (PropertyAccessor accessor : accessors = this.getAccessors(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Checking target: {} descriptor: {}", value.getClass(), (Object)accessor.getName());
            }
            this.validateField(value, context, accessor, node);
        }
    }

    private PropertyAccessor[] getAccessors(Object bean) {
        PropertyAccessor[] accessors = accessorCache.get(bean.getClass());
        if (accessors == null) {
            ArrayList<PropertyAccessor> accessorList = new ArrayList<PropertyAccessor>();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
                for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                    PropertyAccessor accessor;
                    if (descriptor.getReadMethod() == null || (accessor = new PropertyAccessor(bean, descriptor)).getAnnotations().size() <= 0) continue;
                    accessorList.add(accessor);
                }
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
            accessors = (PropertyAccessor[])accessorList.stream().toArray(PropertyAccessor[]::new);
            accessorCache.put(bean.getClass(), accessors);
        }
        return accessors;
    }

    /*
     * WARNING - void declaration
     */
    private <T> void validateField(Object target, ValidationContext context, PropertyAccessor accessor, Node node) {
        String name = accessor.getName();
        Object fieldValue = accessor.get(target);
        Optional<NotNull> notNullAnnotation = accessor.getNotNullAnnotation();
        if (logger.isDebugEnabled()) {
            logger.debug("{}.{}'s notNullAnnotation: {}", new Object[]{node.toString(), accessor.getName(), notNullAnnotation});
        }
        if (fieldValue == null) {
            if (notNullAnnotation.isPresent()) {
                logger.debug("{} is null", (Object)node.toString());
                ConstraintViolation constraintViolation = new ConstraintViolation(fieldValue, notNullAnnotation.get(), node.child(name).toString());
                context.addViolation(constraintViolation);
            }
            return;
        }
        for (Annotation annotation : accessor.getAnnotations()) {
            Optional<ConstraintViolation> constraintViolationOptional = this.validateByAnnotation(annotation, node.child(name).toString(), fieldValue);
            if (!constraintViolationOptional.isPresent()) continue;
            context.addViolation(constraintViolationOptional.get());
        }
        if (accessor.getValidAnnotation().isPresent() && !context.isSeen(fieldValue)) {
            if (fieldValue instanceof Collection) {
                int i = 0;
                for (Object item : (Collection)fieldValue) {
                    this.doValidate(item, context, node.child(name).child("" + i));
                    ++i;
                }
            } else if (fieldValue instanceof Map) {
                for (Object k : ((Map)fieldValue).keySet()) {
                    if (k.getClass().isPrimitive()) continue;
                    this.doValidate(k, context, node.child(name).child("key"));
                }
                for (Object k : ((Map)fieldValue).keySet()) {
                    Object value = ((Map)fieldValue).get(k);
                    this.doValidate(value, context, node.child(name).child(k.toString()));
                }
            } else if (fieldValue.getClass().isArray()) {
                Object[] array = (Object[])fieldValue;
                boolean bl = false;
                for (Object item : array) {
                    void var9_19;
                    this.doValidate(item, context, node.child(name).child("" + (int)var9_19));
                    ++var9_19;
                }
            } else {
                this.doValidate(fieldValue, context, node.child(name));
            }
        }
    }

    public <T> Optional<ConstraintViolation> validateByAnnotation(Annotation annotation, String name, T value) {
        Constraint constraint = annotation.annotationType().getAnnotation(Constraint.class);
        if (constraint == null) {
            logger.debug("{} doesn't have a @Constraint annotation.", (Object)annotation);
            return Optional.empty();
        }
        Class<? extends ConstraintValidator> constraintValidatorClass = constraint.validatedBy();
        ConstraintValidator constraintValidator = constraintValidatorClass.newInstance();
        if (constraintValidator.isValid(annotation, value)) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintViolation(value, annotation, name));
    }
}

