/*
 * Decompiled with CFR 0.152.
 */
package me.geso.tinyvalidator.constraints;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import me.geso.tinyvalidator.Constraint;
import me.geso.tinyvalidator.ConstraintValidator;
import org.apache.commons.validator.routines.EmailValidator;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
@Constraint(validatedBy=Validator.class)
public @interface Email {
    public String message() default "must be valid E-mail addresss";

    public static class Validator
    implements ConstraintValidator {
        @Override
        public boolean isValid(Annotation annotation, Object fieldValue) {
            if (fieldValue == null) {
                return true;
            }
            if (!(fieldValue instanceof String)) {
                return false;
            }
            EmailValidator validator = EmailValidator.getInstance();
            return validator.isValid((String)fieldValue);
        }
    }
}

