/*
 * Decompiled with CFR 0.152.
 */
package me.geso.tinyvalidator.constraints;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.geso.tinyvalidator.Constraint;
import me.geso.tinyvalidator.ConstraintValidator;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
@Constraint(validatedBy=Validator.class)
public @interface HttpUrl {
    public String message() default "must be valid HTTP URL";

    public static class Validator
    implements ConstraintValidator {
        private static final Pattern pattern = Pattern.compile("\\As?https?://[-_.!~*'()a-zA-Z0-9;/?:@&=+$,%#]+\\z");

        @Override
        public boolean isValid(Annotation annotation, Object fieldValue) {
            if (fieldValue == null) {
                return true;
            }
            Matcher matcher = pattern.matcher(fieldValue.toString());
            return matcher.matches();
        }
    }
}

