/*
 * Decompiled with CFR 0.152.
 */
package me.geso.tinyvalidator.rules;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import me.geso.tinyvalidator.ConstraintValidator;
import me.geso.tinyvalidator.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeConstraintValidator
implements ConstraintValidator {
    private static final Logger logger = LoggerFactory.getLogger(SizeConstraintValidator.class);

    @Override
    public boolean isValid(Annotation annotation, Object fieldValue) {
        Size sizeAnnotation = (Size)annotation;
        int size = this.getSize(fieldValue);
        if (size > sizeAnnotation.max()) {
            if (logger.isDebugEnabled()) {
                logger.debug("SizeConstraintValidator: {} > {}", (Object)size, (Object)sizeAnnotation.max());
            }
            return false;
        }
        if (size < sizeAnnotation.min()) {
            if (logger.isDebugEnabled()) {
                logger.debug("SizeConstraintValidator: {} < {}", (Object)size, (Object)sizeAnnotation.min());
            }
            return false;
        }
        return true;
    }

    private int getSize(Object fieldValue) {
        if (fieldValue instanceof CharSequence) {
            return ((CharSequence)fieldValue).length();
        }
        if (fieldValue instanceof Collection) {
            return ((Collection)fieldValue).size();
        }
        if (fieldValue instanceof Map) {
            return ((Map)fieldValue).size();
        }
        if (fieldValue instanceof Object[]) {
            return ((Object[])fieldValue).length;
        }
        if (fieldValue instanceof boolean[]) {
            return ((boolean[])fieldValue).length;
        }
        if (fieldValue instanceof byte[]) {
            return ((byte[])fieldValue).length;
        }
        if (fieldValue instanceof char[]) {
            return ((char[])fieldValue).length;
        }
        if (fieldValue instanceof double[]) {
            return ((double[])fieldValue).length;
        }
        if (fieldValue instanceof float[]) {
            return ((float[])fieldValue).length;
        }
        if (fieldValue instanceof int[]) {
            return ((int[])fieldValue).length;
        }
        if (fieldValue instanceof long[]) {
            return ((long[])fieldValue).length;
        }
        if (fieldValue instanceof short[]) {
            return ((short[])fieldValue).length;
        }
        if (fieldValue == null) {
            throw new RuntimeException("me.geso.tinyvalidator.rules.SizeConstraintValidator: The value is null");
        }
        throw new RuntimeException("me.geso.tinyvalidator.rules.SizeConstraintValidator can't get a size from: " + fieldValue.getClass());
    }
}

