/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.list;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.adapter.list.BaseKubernetesList;
import me.snowdrop.istio.mixer.adapter.list.BaseKubernetesListFluent;
import me.snowdrop.istio.mixer.adapter.list.BaseKubernetesListFluentImpl;

public class BaseKubernetesListBuilder
extends BaseKubernetesListFluentImpl<BaseKubernetesListBuilder>
implements VisitableBuilder<BaseKubernetesList, BaseKubernetesListBuilder> {
    BaseKubernetesListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BaseKubernetesListBuilder() {
        this(true);
    }

    public BaseKubernetesListBuilder(Boolean validationEnabled) {
        this(new BaseKubernetesList(), validationEnabled);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BaseKubernetesList(), validationEnabled);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, BaseKubernetesList instance) {
        this(fluent, instance, true);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, BaseKubernetesList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBlacklist(instance.getBlacklist());
        fluent.withCachingInterval(instance.getCachingInterval());
        fluent.withCachingUseCount(instance.getCachingUseCount());
        fluent.withEntryType(instance.getEntryType());
        fluent.withOverrides(instance.getOverrides());
        fluent.withProviderUrl(instance.getProviderUrl());
        fluent.withRefreshInterval(instance.getRefreshInterval());
        fluent.withTtl(instance.getTtl());
        this.validationEnabled = validationEnabled;
    }

    public BaseKubernetesListBuilder(BaseKubernetesList instance) {
        this(instance, (Boolean)true);
    }

    public BaseKubernetesListBuilder(BaseKubernetesList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBlacklist(instance.getBlacklist());
        this.withCachingInterval(instance.getCachingInterval());
        this.withCachingUseCount(instance.getCachingUseCount());
        this.withEntryType(instance.getEntryType());
        this.withOverrides(instance.getOverrides());
        this.withProviderUrl(instance.getProviderUrl());
        this.withRefreshInterval(instance.getRefreshInterval());
        this.withTtl(instance.getTtl());
        this.validationEnabled = validationEnabled;
    }

    public BaseKubernetesListBuilder(Validator validator) {
        this(new BaseKubernetesList(), (Boolean)true);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, BaseKubernetesList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withBlacklist(instance.getBlacklist());
        fluent.withCachingInterval(instance.getCachingInterval());
        fluent.withCachingUseCount(instance.getCachingUseCount());
        fluent.withEntryType(instance.getEntryType());
        fluent.withOverrides(instance.getOverrides());
        fluent.withProviderUrl(instance.getProviderUrl());
        fluent.withRefreshInterval(instance.getRefreshInterval());
        fluent.withTtl(instance.getTtl());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BaseKubernetesListBuilder(BaseKubernetesList instance, Validator validator) {
        this.fluent = this;
        this.withBlacklist(instance.getBlacklist());
        this.withCachingInterval(instance.getCachingInterval());
        this.withCachingUseCount(instance.getCachingUseCount());
        this.withEntryType(instance.getEntryType());
        this.withOverrides(instance.getOverrides());
        this.withProviderUrl(instance.getProviderUrl());
        this.withRefreshInterval(instance.getRefreshInterval());
        this.withTtl(instance.getTtl());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BaseKubernetesList build() {
        BaseKubernetesList buildable = new BaseKubernetesList(this.fluent.isBlacklist(), this.fluent.getCachingInterval(), this.fluent.getCachingUseCount(), this.fluent.getEntryType(), this.fluent.getOverrides(), this.fluent.getProviderUrl(), this.fluent.getRefreshInterval(), this.fluent.getTtl());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseKubernetesListBuilder that = (BaseKubernetesListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

