package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class AnyFluentImpl<A extends AnyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AnyFluent<A>{

    private String typeUrl;
    private String value;

    public AnyFluentImpl(){
    }
    public AnyFluentImpl(Any instance){
            this.withTypeUrl(instance.getTypeUrl()); 
            this.withValue(instance.getValue()); 
    }

    public String getTypeUrl(){
            return this.typeUrl;
    }

    public A withTypeUrl(String typeUrl){
            this.typeUrl=typeUrl; return (A) this;
    }

    public Boolean hasTypeUrl(){
            return this.typeUrl != null;
    }

    public String getValue(){
            return this.value;
    }

    public A withValue(String value){
            this.value=value; return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AnyFluentImpl that = (AnyFluentImpl) o;
            if (typeUrl != null ? !typeUrl.equals(that.typeUrl) :that.typeUrl != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }




}
