package me.snowdrop.istio.api;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class StatusBuilder extends StatusFluentImpl<StatusBuilder> implements VisitableBuilder<me.snowdrop.istio.api.Status,StatusBuilder>{

    StatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StatusBuilder(){
            this(true);
    }
    public StatusBuilder(Boolean validationEnabled){
            this(new Status(), validationEnabled);
    }
    public StatusBuilder(StatusFluent<?> fluent){
            this(fluent, true);
    }
    public StatusBuilder(StatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Status(), validationEnabled);
    }
    public StatusBuilder(StatusFluent<?> fluent,me.snowdrop.istio.api.Status instance){
            this(fluent, instance, true);
    }
    public StatusBuilder(StatusFluent<?> fluent,me.snowdrop.istio.api.Status instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCode(instance.getCode()); 
            fluent.withDetails(instance.getDetails()); 
            fluent.withMessage(instance.getMessage()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatusBuilder(me.snowdrop.istio.api.Status instance){
            this(instance,true);
    }
    public StatusBuilder(me.snowdrop.istio.api.Status instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCode(instance.getCode()); 
            this.withDetails(instance.getDetails()); 
            this.withMessage(instance.getMessage()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatusBuilder(Validator validator){
            this(new Status(), true);
    }
    public StatusBuilder(StatusFluent<?> fluent,me.snowdrop.istio.api.Status instance,Validator validator){
            this.fluent = fluent; 
            fluent.withCode(instance.getCode()); 
            fluent.withDetails(instance.getDetails()); 
            fluent.withMessage(instance.getMessage()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public StatusBuilder(me.snowdrop.istio.api.Status instance,Validator validator){
            this.fluent = this; 
            this.withCode(instance.getCode()); 
            this.withDetails(instance.getDetails()); 
            this.withMessage(instance.getMessage()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public me.snowdrop.istio.api.Status build(){
            Status buildable = new Status(fluent.getCode(),fluent.getDetails(),fluent.getMessage());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatusBuilder that = (StatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
