package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Predicate;

public interface JwtFluent<A extends JwtFluent<A>> extends Fluent<A>{


    public A addToAudiences(int index,String item);
    public A setToAudiences(int index,String item);
    public A addToAudiences(String... items);
    public A addAllToAudiences(Collection<String> items);
    public A removeFromAudiences(String... items);
    public A removeAllFromAudiences(Collection<String> items);
    public List<String> getAudiences();
    public String getAudience(int index);
    public String getFirstAudience();
    public String getLastAudience();
    public String getMatchingAudience(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAudiences(List<String> audiences);
    public A withAudiences(String... audiences);
    public Boolean hasAudiences();
    public String getIssuer();
    public A withIssuer(String issuer);
    public Boolean hasIssuer();
    public String getJwksUri();
    public A withJwksUri(String jwksUri);
    public Boolean hasJwksUri();
    public A addToJwtHeaders(int index,String item);
    public A setToJwtHeaders(int index,String item);
    public A addToJwtHeaders(String... items);
    public A addAllToJwtHeaders(Collection<String> items);
    public A removeFromJwtHeaders(String... items);
    public A removeAllFromJwtHeaders(Collection<String> items);
    public List<String> getJwtHeaders();
    public String getJwtHeader(int index);
    public String getFirstJwtHeader();
    public String getLastJwtHeader();
    public String getMatchingJwtHeader(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withJwtHeaders(List<String> jwtHeaders);
    public A withJwtHeaders(String... jwtHeaders);
    public Boolean hasJwtHeaders();
    public A addToJwtParams(int index,String item);
    public A setToJwtParams(int index,String item);
    public A addToJwtParams(String... items);
    public A addAllToJwtParams(Collection<String> items);
    public A removeFromJwtParams(String... items);
    public A removeAllFromJwtParams(Collection<String> items);
    public List<String> getJwtParams();
    public String getJwtParam(int index);
    public String getFirstJwtParam();
    public String getLastJwtParam();
    public String getMatchingJwtParam(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withJwtParams(List<String> jwtParams);
    public A withJwtParams(String... jwtParams);
    public Boolean hasJwtParams();



}
