package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class NamePortBuilder extends NamePortFluentImpl<NamePortBuilder> implements VisitableBuilder<NamePort,NamePortBuilder>{

    NamePortFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NamePortBuilder(){
            this(true);
    }
    public NamePortBuilder(Boolean validationEnabled){
            this(new NamePort(), validationEnabled);
    }
    public NamePortBuilder(NamePortFluent<?> fluent){
            this(fluent, true);
    }
    public NamePortBuilder(NamePortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NamePort(), validationEnabled);
    }
    public NamePortBuilder(NamePortFluent<?> fluent,NamePort instance){
            this(fluent, instance, true);
    }
    public NamePortBuilder(NamePortFluent<?> fluent,NamePort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamePortBuilder(NamePort instance){
            this(instance,true);
    }
    public NamePortBuilder(NamePort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamePortBuilder(Validator validator){
            this(new NamePort(), true);
    }
    public NamePortBuilder(NamePortFluent<?> fluent,NamePort instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public NamePortBuilder(NamePort instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public NamePort build(){
            NamePort buildable = new NamePort(fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamePortBuilder that = (NamePortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
