package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class OriginAuthenticationMethodBuilder extends OriginAuthenticationMethodFluentImpl<OriginAuthenticationMethodBuilder> implements VisitableBuilder<OriginAuthenticationMethod,OriginAuthenticationMethodBuilder>{

    OriginAuthenticationMethodFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OriginAuthenticationMethodBuilder(){
            this(true);
    }
    public OriginAuthenticationMethodBuilder(Boolean validationEnabled){
            this(new OriginAuthenticationMethod(), validationEnabled);
    }
    public OriginAuthenticationMethodBuilder(OriginAuthenticationMethodFluent<?> fluent){
            this(fluent, true);
    }
    public OriginAuthenticationMethodBuilder(OriginAuthenticationMethodFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OriginAuthenticationMethod(), validationEnabled);
    }
    public OriginAuthenticationMethodBuilder(OriginAuthenticationMethodFluent<?> fluent,OriginAuthenticationMethod instance){
            this(fluent, instance, true);
    }
    public OriginAuthenticationMethodBuilder(OriginAuthenticationMethodFluent<?> fluent,OriginAuthenticationMethod instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withJwt(instance.getJwt()); 
            this.validationEnabled = validationEnabled; 
    }
    public OriginAuthenticationMethodBuilder(OriginAuthenticationMethod instance){
            this(instance,true);
    }
    public OriginAuthenticationMethodBuilder(OriginAuthenticationMethod instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withJwt(instance.getJwt()); 
            this.validationEnabled = validationEnabled; 
    }
    public OriginAuthenticationMethodBuilder(Validator validator){
            this(new OriginAuthenticationMethod(), true);
    }
    public OriginAuthenticationMethodBuilder(OriginAuthenticationMethodFluent<?> fluent,OriginAuthenticationMethod instance,Validator validator){
            this.fluent = fluent; 
            fluent.withJwt(instance.getJwt()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public OriginAuthenticationMethodBuilder(OriginAuthenticationMethod instance,Validator validator){
            this.fluent = this; 
            this.withJwt(instance.getJwt()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public OriginAuthenticationMethod build(){
            OriginAuthenticationMethod buildable = new OriginAuthenticationMethod(fluent.getJwt());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OriginAuthenticationMethodBuilder that = (OriginAuthenticationMethodBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
