package me.snowdrop.istio.api.authentication.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public interface TargetSelectorFluent<A extends TargetSelectorFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A addToPorts(int index,PortSelector item);
    public A setToPorts(int index,PortSelector item);
    public A addToPorts(PortSelector... items);
    public A addAllToPorts(Collection<PortSelector> items);
    public A removeFromPorts(PortSelector... items);
    public A removeAllFromPorts(Collection<PortSelector> items);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<PortSelector> getPorts();
    public List<PortSelector> buildPorts();
    public PortSelector buildPort(int index);
    public PortSelector buildFirstPort();
    public PortSelector buildLastPort();
    public PortSelector buildMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortSelectorBuilder> predicate);
    public A withPorts(List<PortSelector> ports);
    public A withPorts(PortSelector... ports);
    public Boolean hasPorts();
    public TargetSelectorFluent.PortsNested<A> addNewPort();
    public TargetSelectorFluent.PortsNested<A> addNewPortLike(PortSelector item);
    public TargetSelectorFluent.PortsNested<A> setNewPortLike(int index,PortSelector item);
    public TargetSelectorFluent.PortsNested<A> editPort(int index);
    public TargetSelectorFluent.PortsNested<A> editFirstPort();
    public TargetSelectorFluent.PortsNested<A> editLastPort();
    public TargetSelectorFluent.PortsNested<A> editMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortSelectorBuilder> predicate);

    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PortSelectorFluent<TargetSelectorFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}


}
