package me.snowdrop.istio.api.mesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.DurationFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import me.snowdrop.istio.api.DurationBuilder;

public interface MeshConfigFluent<A extends MeshConfigFluent<A>> extends Fluent<A>{


    public String getAccessLogFile();
    public A withAccessLogFile(String accessLogFile);
    public Boolean hasAccessLogFile();
    public AuthenticationPolicy getAuthPolicy();
    public A withAuthPolicy(AuthenticationPolicy authPolicy);
    public Boolean hasAuthPolicy();
    
/**
 * This method has been deprecated, please use method buildConnectTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getConnectTimeout();
    public Duration buildConnectTimeout();
    public A withConnectTimeout(Duration connectTimeout);
    public Boolean hasConnectTimeout();
    public A withNewConnectTimeout(Integer nanos,Long seconds);
    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeout();
    public MeshConfigFluent.ConnectTimeoutNested<A> withNewConnectTimeoutLike(Duration item);
    public MeshConfigFluent.ConnectTimeoutNested<A> editConnectTimeout();
    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeout();
    public MeshConfigFluent.ConnectTimeoutNested<A> editOrNewConnectTimeoutLike(Duration item);
    
/**
 * This method has been deprecated, please use method buildDefaultConfig instead.
 * @return The buildable object.
 */
@Deprecated public ProxyConfig getDefaultConfig();
    public ProxyConfig buildDefaultConfig();
    public A withDefaultConfig(ProxyConfig defaultConfig);
    public Boolean hasDefaultConfig();
    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfig();
    public MeshConfigFluent.DefaultConfigNested<A> withNewDefaultConfigLike(ProxyConfig item);
    public MeshConfigFluent.DefaultConfigNested<A> editDefaultConfig();
    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfig();
    public MeshConfigFluent.DefaultConfigNested<A> editOrNewDefaultConfigLike(ProxyConfig item);
    public Boolean isDisablePolicyChecks();
    public A withDisablePolicyChecks(Boolean disablePolicyChecks);
    public Boolean hasDisablePolicyChecks();
    public A withNewDisablePolicyChecks(String arg1);
    public A withNewDisablePolicyChecks(boolean arg1);
    public Boolean isEnableClientSidePolicyCheck();
    public A withEnableClientSidePolicyCheck(Boolean enableClientSidePolicyCheck);
    public Boolean hasEnableClientSidePolicyCheck();
    public A withNewEnableClientSidePolicyCheck(String arg1);
    public A withNewEnableClientSidePolicyCheck(boolean arg1);
    public Boolean isEnableTracing();
    public A withEnableTracing(Boolean enableTracing);
    public Boolean hasEnableTracing();
    public A withNewEnableTracing(String arg1);
    public A withNewEnableTracing(boolean arg1);
    public String getIngressClass();
    public A withIngressClass(String ingressClass);
    public Boolean hasIngressClass();
    public IngressControllerMode getIngressControllerMode();
    public A withIngressControllerMode(IngressControllerMode ingressControllerMode);
    public Boolean hasIngressControllerMode();
    public String getIngressService();
    public A withIngressService(String ingressService);
    public Boolean hasIngressService();
    public String getMixerAddress();
    public A withMixerAddress(String mixerAddress);
    public Boolean hasMixerAddress();
    public String getMixerCheckServer();
    public A withMixerCheckServer(String mixerCheckServer);
    public Boolean hasMixerCheckServer();
    public String getMixerReportServer();
    public A withMixerReportServer(String mixerReportServer);
    public Boolean hasMixerReportServer();
    
/**
 * This method has been deprecated, please use method buildOutboundTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public OutboundTrafficPolicy getOutboundTrafficPolicy();
    public OutboundTrafficPolicy buildOutboundTrafficPolicy();
    public A withOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy);
    public Boolean hasOutboundTrafficPolicy();
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy();
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item);
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy();
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy();
    public MeshConfigFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item);
    public Boolean isPolicyCheckFailOpen();
    public A withPolicyCheckFailOpen(Boolean policyCheckFailOpen);
    public Boolean hasPolicyCheckFailOpen();
    public A withNewPolicyCheckFailOpen(String arg1);
    public A withNewPolicyCheckFailOpen(boolean arg1);
    public Integer getProxyHttpPort();
    public A withProxyHttpPort(Integer proxyHttpPort);
    public Boolean hasProxyHttpPort();
    public A withNewProxyHttpPort(String arg1);
    public A withNewProxyHttpPort(int arg1);
    public Integer getProxyListenPort();
    public A withProxyListenPort(Integer proxyListenPort);
    public Boolean hasProxyListenPort();
    public A withNewProxyListenPort(String arg1);
    public A withNewProxyListenPort(int arg1);
    
/**
 * This method has been deprecated, please use method buildRdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getRdsRefreshDelay();
    public Duration buildRdsRefreshDelay();
    public A withRdsRefreshDelay(Duration rdsRefreshDelay);
    public Boolean hasRdsRefreshDelay();
    public A withNewRdsRefreshDelay(Integer nanos,Long seconds);
    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelay();
    public MeshConfigFluent.RdsRefreshDelayNested<A> withNewRdsRefreshDelayLike(Duration item);
    public MeshConfigFluent.RdsRefreshDelayNested<A> editRdsRefreshDelay();
    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelay();
    public MeshConfigFluent.RdsRefreshDelayNested<A> editOrNewRdsRefreshDelayLike(Duration item);
    
/**
 * This method has been deprecated, please use method buildSdsRefreshDelay instead.
 * @return The buildable object.
 */
@Deprecated public Duration getSdsRefreshDelay();
    public Duration buildSdsRefreshDelay();
    public A withSdsRefreshDelay(Duration sdsRefreshDelay);
    public Boolean hasSdsRefreshDelay();
    public A withNewSdsRefreshDelay(Integer nanos,Long seconds);
    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelay();
    public MeshConfigFluent.SdsRefreshDelayNested<A> withNewSdsRefreshDelayLike(Duration item);
    public MeshConfigFluent.SdsRefreshDelayNested<A> editSdsRefreshDelay();
    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelay();
    public MeshConfigFluent.SdsRefreshDelayNested<A> editOrNewSdsRefreshDelayLike(Duration item);
    public String getSdsUdsPath();
    public A withSdsUdsPath(String sdsUdsPath);
    public Boolean hasSdsUdsPath();

    public interface ConnectTimeoutNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<MeshConfigFluent.ConnectTimeoutNested<N>>{

        
    public N and();    public N endConnectTimeout();
}
    public interface DefaultConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyConfigFluent<MeshConfigFluent.DefaultConfigNested<N>>{

        
    public N and();    public N endDefaultConfig();
}
    public interface OutboundTrafficPolicyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OutboundTrafficPolicyFluent<MeshConfigFluent.OutboundTrafficPolicyNested<N>>{

        
    public N and();    public N endOutboundTrafficPolicy();
}
    public interface RdsRefreshDelayNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<MeshConfigFluent.RdsRefreshDelayNested<N>>{

        
    public N and();    public N endRdsRefreshDelay();
}
    public interface SdsRefreshDelayNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<MeshConfigFluent.SdsRefreshDelayNested<N>>{

        
    public N and();    public N endSdsRefreshDelay();
}


}
