package me.snowdrop.istio.api.mixer.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class CheckResponseFluentImpl<A extends CheckResponseFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CheckResponseFluent<A>{

    private PreconditionResultBuilder precondition;
    private Map<String,QuotaResult> quotas;

    public CheckResponseFluentImpl(){
    }
    public CheckResponseFluentImpl(CheckResponse instance){
            this.withPrecondition(instance.getPrecondition()); 
            this.withQuotas(instance.getQuotas()); 
    }

    
/**
 * This method has been deprecated, please use method buildPrecondition instead.
 * @return The buildable object.
 */
@Deprecated public PreconditionResult getPrecondition(){
            return this.precondition!=null?this.precondition.build():null;
    }

    public PreconditionResult buildPrecondition(){
            return this.precondition!=null?this.precondition.build():null;
    }

    public A withPrecondition(PreconditionResult precondition){
            _visitables.remove(this.precondition);
            if (precondition!=null){ this.precondition= new PreconditionResultBuilder(precondition); _visitables.add(this.precondition);} return (A) this;
    }

    public Boolean hasPrecondition(){
            return this.precondition != null;
    }

    public CheckResponseFluent.PreconditionNested<A> withNewPrecondition(){
            return new PreconditionNestedImpl();
    }

    public CheckResponseFluent.PreconditionNested<A> withNewPreconditionLike(PreconditionResult item){
            return new PreconditionNestedImpl(item);
    }

    public CheckResponseFluent.PreconditionNested<A> editPrecondition(){
            return withNewPreconditionLike(getPrecondition());
    }

    public CheckResponseFluent.PreconditionNested<A> editOrNewPrecondition(){
            return withNewPreconditionLike(getPrecondition() != null ? getPrecondition(): new PreconditionResultBuilder().build());
    }

    public CheckResponseFluent.PreconditionNested<A> editOrNewPreconditionLike(PreconditionResult item){
            return withNewPreconditionLike(getPrecondition() != null ? getPrecondition(): item);
    }

    public A addToQuotas(String key,QuotaResult value){
            if(this.quotas == null && key != null && value != null) { this.quotas = new LinkedHashMap<String,QuotaResult>(); }
            if(key != null && value != null) {this.quotas.put(key, value);} return (A)this;
    }

    public A addToQuotas(Map<String,QuotaResult> map){
            if(this.quotas == null && map != null) { this.quotas = new LinkedHashMap<String,QuotaResult>(); }
            if(map != null) { this.quotas.putAll(map);} return (A)this;
    }

    public A removeFromQuotas(String key){
            if(this.quotas == null) { return (A) this; }
            if(key != null && this.quotas != null) {this.quotas.remove(key);} return (A)this;
    }

    public A removeFromQuotas(Map<String,QuotaResult> map){
            if(this.quotas == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.quotas != null){this.quotas.remove(key);}}} return (A)this;
    }

    public Map<String,QuotaResult> getQuotas(){
            return this.quotas;
    }

    public A withQuotas(Map<String,QuotaResult> quotas){
            if (quotas == null) { this.quotas =  null;} else {this.quotas = new LinkedHashMap<String,QuotaResult>(quotas);} return (A) this;
    }

    public Boolean hasQuotas(){
            return this.quotas != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CheckResponseFluentImpl that = (CheckResponseFluentImpl) o;
            if (precondition != null ? !precondition.equals(that.precondition) :that.precondition != null) return false;
            if (quotas != null ? !quotas.equals(that.quotas) :that.quotas != null) return false;
            return true;
    }


    public class PreconditionNestedImpl<N> extends PreconditionResultFluentImpl<CheckResponseFluent.PreconditionNested<N>> implements CheckResponseFluent.PreconditionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PreconditionResultBuilder builder;
    
            PreconditionNestedImpl(PreconditionResult item){
                    this.builder = new PreconditionResultBuilder(this, item);
            }
            PreconditionNestedImpl(){
                    this.builder = new PreconditionResultBuilder(this);
            }
    
    public N and(){
            return (N) CheckResponseFluentImpl.this.withPrecondition(builder.build());
    }
    public N endPrecondition(){
            return and();
    }

}


}
