package me.snowdrop.istio.api.mixer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class HeaderOperationBuilder extends HeaderOperationFluentImpl<HeaderOperationBuilder> implements VisitableBuilder<HeaderOperation,HeaderOperationBuilder>{

    HeaderOperationFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HeaderOperationBuilder(){
            this(true);
    }
    public HeaderOperationBuilder(Boolean validationEnabled){
            this(new HeaderOperation(), validationEnabled);
    }
    public HeaderOperationBuilder(HeaderOperationFluent<?> fluent){
            this(fluent, true);
    }
    public HeaderOperationBuilder(HeaderOperationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HeaderOperation(), validationEnabled);
    }
    public HeaderOperationBuilder(HeaderOperationFluent<?> fluent,HeaderOperation instance){
            this(fluent, instance, true);
    }
    public HeaderOperationBuilder(HeaderOperationFluent<?> fluent,HeaderOperation instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withOperation(instance.getOperation()); 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public HeaderOperationBuilder(HeaderOperation instance){
            this(instance,true);
    }
    public HeaderOperationBuilder(HeaderOperation instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withOperation(instance.getOperation()); 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public HeaderOperationBuilder(Validator validator){
            this(new HeaderOperation(), true);
    }
    public HeaderOperationBuilder(HeaderOperationFluent<?> fluent,HeaderOperation instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withOperation(instance.getOperation()); 
            fluent.withValue(instance.getValue()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public HeaderOperationBuilder(HeaderOperation instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withOperation(instance.getOperation()); 
            this.withValue(instance.getValue()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public HeaderOperation build(){
            HeaderOperation buildable = new HeaderOperation(fluent.getName(),fluent.getOperation(),fluent.getValue());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HeaderOperationBuilder that = (HeaderOperationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
