package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class DestinationBuilder extends DestinationFluentImpl<DestinationBuilder> implements VisitableBuilder<Destination,DestinationBuilder>{

    DestinationFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DestinationBuilder(){
            this(true);
    }
    public DestinationBuilder(Boolean validationEnabled){
            this(new Destination(), validationEnabled);
    }
    public DestinationBuilder(DestinationFluent<?> fluent){
            this(fluent, true);
    }
    public DestinationBuilder(DestinationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Destination(), validationEnabled);
    }
    public DestinationBuilder(DestinationFluent<?> fluent,Destination instance){
            this(fluent, instance, true);
    }
    public DestinationBuilder(DestinationFluent<?> fluent,Destination instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHost(instance.getHost()); 
            fluent.withPort(instance.getPort()); 
            fluent.withSubset(instance.getSubset()); 
            this.validationEnabled = validationEnabled; 
    }
    public DestinationBuilder(Destination instance){
            this(instance,true);
    }
    public DestinationBuilder(Destination instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHost(instance.getHost()); 
            this.withPort(instance.getPort()); 
            this.withSubset(instance.getSubset()); 
            this.validationEnabled = validationEnabled; 
    }
    public DestinationBuilder(Validator validator){
            this(new Destination(), true);
    }
    public DestinationBuilder(DestinationFluent<?> fluent,Destination instance,Validator validator){
            this.fluent = fluent; 
            fluent.withHost(instance.getHost()); 
            fluent.withPort(instance.getPort()); 
            fluent.withSubset(instance.getSubset()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public DestinationBuilder(Destination instance,Validator validator){
            this.fluent = this; 
            this.withHost(instance.getHost()); 
            this.withPort(instance.getPort()); 
            this.withSubset(instance.getSubset()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Destination build(){
            Destination buildable = new Destination(fluent.getHost(),fluent.getPort(),fluent.getSubset());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DestinationBuilder that = (DestinationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
