
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "name",
    "path",
    "ttl"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPCookie implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     * 
     */
    @JsonProperty("path")
    @JsonPropertyDescription("")
    private String path;
    /**
     * 
     * 
     */
    @JsonProperty("ttl")
    @JsonPropertyDescription("")
    private Long ttl;
    private final static long serialVersionUID = -724975125087326734L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPCookie() {
    }

    /**
     * 
     * @param path
     * @param name
     * @param ttl
     */
    public HTTPCookie(String name, String path, Long ttl) {
        super();
        this.name = name;
        this.path = path;
        this.ttl = ttl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("path")
    public String getPath() {
        return path;
    }

    /**
     * 
     * 
     */
    @JsonProperty("path")
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ttl")
    public Long getTtl() {
        return ttl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ttl")
    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

}
