package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class HTTPFaultInjectionBuilder extends HTTPFaultInjectionFluentImpl<HTTPFaultInjectionBuilder> implements VisitableBuilder<HTTPFaultInjection,HTTPFaultInjectionBuilder>{

    HTTPFaultInjectionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPFaultInjectionBuilder(){
            this(true);
    }
    public HTTPFaultInjectionBuilder(Boolean validationEnabled){
            this(new HTTPFaultInjection(), validationEnabled);
    }
    public HTTPFaultInjectionBuilder(HTTPFaultInjectionFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPFaultInjectionBuilder(HTTPFaultInjectionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPFaultInjection(), validationEnabled);
    }
    public HTTPFaultInjectionBuilder(HTTPFaultInjectionFluent<?> fluent,HTTPFaultInjection instance){
            this(fluent, instance, true);
    }
    public HTTPFaultInjectionBuilder(HTTPFaultInjectionFluent<?> fluent,HTTPFaultInjection instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAbort(instance.getAbort()); 
            fluent.withDelay(instance.getDelay()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPFaultInjectionBuilder(HTTPFaultInjection instance){
            this(instance,true);
    }
    public HTTPFaultInjectionBuilder(HTTPFaultInjection instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAbort(instance.getAbort()); 
            this.withDelay(instance.getDelay()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPFaultInjectionBuilder(Validator validator){
            this(new HTTPFaultInjection(), true);
    }
    public HTTPFaultInjectionBuilder(HTTPFaultInjectionFluent<?> fluent,HTTPFaultInjection instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAbort(instance.getAbort()); 
            fluent.withDelay(instance.getDelay()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public HTTPFaultInjectionBuilder(HTTPFaultInjection instance,Validator validator){
            this.fluent = this; 
            this.withAbort(instance.getAbort()); 
            this.withDelay(instance.getDelay()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public HTTPFaultInjection build(){
            HTTPFaultInjection buildable = new HTTPFaultInjection(fluent.getAbort(),fluent.getDelay());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPFaultInjectionBuilder that = (HTTPFaultInjectionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
