package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import me.snowdrop.istio.api.DurationFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.Duration;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.DurationBuilder;

public interface HTTPRetryFluent<A extends HTTPRetryFluent<A>> extends Fluent<A>{


    public Integer getAttempts();
    public A withAttempts(Integer attempts);
    public Boolean hasAttempts();
    public A withNewAttempts(String arg1);
    public A withNewAttempts(int arg1);
    
/**
 * This method has been deprecated, please use method buildPerTryTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getPerTryTimeout();
    public Duration buildPerTryTimeout();
    public A withPerTryTimeout(Duration perTryTimeout);
    public Boolean hasPerTryTimeout();
    public A withNewPerTryTimeout(Integer nanos,Long seconds);
    public HTTPRetryFluent.PerTryTimeoutNested<A> withNewPerTryTimeout();
    public HTTPRetryFluent.PerTryTimeoutNested<A> withNewPerTryTimeoutLike(Duration item);
    public HTTPRetryFluent.PerTryTimeoutNested<A> editPerTryTimeout();
    public HTTPRetryFluent.PerTryTimeoutNested<A> editOrNewPerTryTimeout();
    public HTTPRetryFluent.PerTryTimeoutNested<A> editOrNewPerTryTimeoutLike(Duration item);

    public interface PerTryTimeoutNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<HTTPRetryFluent.PerTryTimeoutNested<N>>{

        
    public N and();    public N endPerTryTimeout();
}


}
