package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class HTTPRewriteFluentImpl<A extends HTTPRewriteFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTTPRewriteFluent<A>{

    private String authority;
    private String uri;

    public HTTPRewriteFluentImpl(){
    }
    public HTTPRewriteFluentImpl(HTTPRewrite instance){
            this.withAuthority(instance.getAuthority()); 
            this.withUri(instance.getUri()); 
    }

    public String getAuthority(){
            return this.authority;
    }

    public A withAuthority(String authority){
            this.authority=authority; return (A) this;
    }

    public Boolean hasAuthority(){
            return this.authority != null;
    }

    public String getUri(){
            return this.uri;
    }

    public A withUri(String uri){
            this.uri=uri; return (A) this;
    }

    public Boolean hasUri(){
            return this.uri != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPRewriteFluentImpl that = (HTTPRewriteFluentImpl) o;
            if (authority != null ? !authority.equals(that.authority) :that.authority != null) return false;
            if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
            return true;
    }




}
