
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "http1MaxPendingRequests",
    "http2MaxRequests",
    "maxRequestsPerConnection",
    "maxRetries"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class HTTPSettings implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("http1MaxPendingRequests")
    @JsonPropertyDescription("")
    private Integer http1MaxPendingRequests;
    /**
     * 
     * 
     */
    @JsonProperty("http2MaxRequests")
    @JsonPropertyDescription("")
    private Integer http2MaxRequests;
    /**
     * 
     * 
     */
    @JsonProperty("maxRequestsPerConnection")
    @JsonPropertyDescription("")
    private Integer maxRequestsPerConnection;
    /**
     * 
     * 
     */
    @JsonProperty("maxRetries")
    @JsonPropertyDescription("")
    private Integer maxRetries;
    private final static long serialVersionUID = -6639889983580757195L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HTTPSettings() {
    }

    /**
     * 
     * @param http2MaxRequests
     * @param maxRetries
     * @param http1MaxPendingRequests
     * @param maxRequestsPerConnection
     */
    public HTTPSettings(Integer http1MaxPendingRequests, Integer http2MaxRequests, Integer maxRequestsPerConnection, Integer maxRetries) {
        super();
        this.http1MaxPendingRequests = http1MaxPendingRequests;
        this.http2MaxRequests = http2MaxRequests;
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        this.maxRetries = maxRetries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http1MaxPendingRequests")
    public Integer getHttp1MaxPendingRequests() {
        return http1MaxPendingRequests;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http1MaxPendingRequests")
    public void setHttp1MaxPendingRequests(Integer http1MaxPendingRequests) {
        this.http1MaxPendingRequests = http1MaxPendingRequests;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http2MaxRequests")
    public Integer getHttp2MaxRequests() {
        return http2MaxRequests;
    }

    /**
     * 
     * 
     */
    @JsonProperty("http2MaxRequests")
    public void setHttp2MaxRequests(Integer http2MaxRequests) {
        this.http2MaxRequests = http2MaxRequests;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxRequestsPerConnection")
    public Integer getMaxRequestsPerConnection() {
        return maxRequestsPerConnection;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxRequestsPerConnection")
    public void setMaxRequestsPerConnection(Integer maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxRetries")
    public Integer getMaxRetries() {
        return maxRetries;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxRetries")
    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

}
