package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ListenerMatchFluentImpl<A extends ListenerMatchFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ListenerMatchFluent<A>{

    private List<String> address;
    private ListenerProtocol listenerProtocol;
    private ListenerType listenerType;
    private String portNamePrefix;
    private Integer portNumber;

    public ListenerMatchFluentImpl(){
    }
    public ListenerMatchFluentImpl(ListenerMatch instance){
            this.withAddress(instance.getAddress()); 
            this.withListenerProtocol(instance.getListenerProtocol()); 
            this.withListenerType(instance.getListenerType()); 
            this.withPortNamePrefix(instance.getPortNamePrefix()); 
            this.withPortNumber(instance.getPortNumber()); 
    }

    public A addToAddress(int index,String item){
            if (this.address == null) {this.address = new ArrayList<String>();}
            this.address.add(index, item);
            return (A)this;
    }

    public A setToAddress(int index,String item){
            if (this.address == null) {this.address = new ArrayList<String>();}
            this.address.set(index, item); return (A)this;
    }

    public A addToAddress(String... items){
            if (this.address == null) {this.address = new ArrayList<String>();}
            for (String item : items) {this.address.add(item);} return (A)this;
    }

    public A addAllToAddress(Collection<String> items){
            if (this.address == null) {this.address = new ArrayList<String>();}
            for (String item : items) {this.address.add(item);} return (A)this;
    }

    public A removeFromAddress(String... items){
            for (String item : items) {if (this.address!= null){ this.address.remove(item);}} return (A)this;
    }

    public A removeAllFromAddress(Collection<String> items){
            for (String item : items) {if (this.address!= null){ this.address.remove(item);}} return (A)this;
    }

    public List<String> getAddress(){
            return this.address;
    }

    public String getAddress(int index){
            return this.address.get(index);
    }

    public String getFirstAddress(){
            return this.address.get(0);
    }

    public String getLastAddress(){
            return this.address.get(address.size() - 1);
    }

    public String getMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: address) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withAddress(List<String> address){
            if (this.address != null) { _visitables.removeAll(this.address);}
            if (address != null) {this.address = new ArrayList<String>(); for (String item : address){this.addToAddress(item);}} else { this.address = null;} return (A) this;
    }

    public A withAddress(String... address){
            if (this.address != null) {this.address.clear();}
            if (address != null) {for (String item :address){ this.addToAddress(item);}} return (A) this;
    }

    public Boolean hasAddress(){
            return address != null && !address.isEmpty();
    }

    public ListenerProtocol getListenerProtocol(){
            return this.listenerProtocol;
    }

    public A withListenerProtocol(ListenerProtocol listenerProtocol){
            this.listenerProtocol=listenerProtocol; return (A) this;
    }

    public Boolean hasListenerProtocol(){
            return this.listenerProtocol != null;
    }

    public ListenerType getListenerType(){
            return this.listenerType;
    }

    public A withListenerType(ListenerType listenerType){
            this.listenerType=listenerType; return (A) this;
    }

    public Boolean hasListenerType(){
            return this.listenerType != null;
    }

    public String getPortNamePrefix(){
            return this.portNamePrefix;
    }

    public A withPortNamePrefix(String portNamePrefix){
            this.portNamePrefix=portNamePrefix; return (A) this;
    }

    public Boolean hasPortNamePrefix(){
            return this.portNamePrefix != null;
    }

    public Integer getPortNumber(){
            return this.portNumber;
    }

    public A withPortNumber(Integer portNumber){
            this.portNumber=portNumber; return (A) this;
    }

    public Boolean hasPortNumber(){
            return this.portNumber != null;
    }

    public A withNewPortNumber(String arg1){
            return (A)withPortNumber(new Integer(arg1));
    }

    public A withNewPortNumber(int arg1){
            return (A)withPortNumber(new Integer(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ListenerMatchFluentImpl that = (ListenerMatchFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (listenerProtocol != null ? !listenerProtocol.equals(that.listenerProtocol) :that.listenerProtocol != null) return false;
            if (listenerType != null ? !listenerType.equals(that.listenerType) :that.listenerType != null) return false;
            if (portNamePrefix != null ? !portNamePrefix.equals(that.portNamePrefix) :that.portNamePrefix != null) return false;
            if (portNumber != null ? !portNumber.equals(that.portNumber) :that.portNumber != null) return false;
            return true;
    }




}
