package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface VirtualServiceFluent<A extends VirtualServiceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public VirtualServiceFluent.MetadataNested<A> withNewMetadata();
    public VirtualServiceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public VirtualServiceFluent.MetadataNested<A> editMetadata();
    public VirtualServiceFluent.MetadataNested<A> editOrNewMetadata();
    public VirtualServiceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public VirtualServiceSpec getSpec();
    public VirtualServiceSpec buildSpec();
    public A withSpec(VirtualServiceSpec spec);
    public Boolean hasSpec();
    public VirtualServiceFluent.SpecNested<A> withNewSpec();
    public VirtualServiceFluent.SpecNested<A> withNewSpecLike(VirtualServiceSpec item);
    public VirtualServiceFluent.SpecNested<A> editSpec();
    public VirtualServiceFluent.SpecNested<A> editOrNewSpec();
    public VirtualServiceFluent.SpecNested<A> editOrNewSpecLike(VirtualServiceSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<VirtualServiceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,VirtualServiceSpecFluent<VirtualServiceFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
