package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class VirtualServiceSpecBuilder extends VirtualServiceSpecFluentImpl<VirtualServiceSpecBuilder> implements VisitableBuilder<VirtualServiceSpec,VirtualServiceSpecBuilder>{

    VirtualServiceSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public VirtualServiceSpecBuilder(){
            this(true);
    }
    public VirtualServiceSpecBuilder(Boolean validationEnabled){
            this(new VirtualServiceSpec(), validationEnabled);
    }
    public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent){
            this(fluent, true);
    }
    public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new VirtualServiceSpec(), validationEnabled);
    }
    public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent,VirtualServiceSpec instance){
            this(fluent, instance, true);
    }
    public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent,VirtualServiceSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGateways(instance.getGateways()); 
            fluent.withHosts(instance.getHosts()); 
            fluent.withHttp(instance.getHttp()); 
            fluent.withTcp(instance.getTcp()); 
            fluent.withTls(instance.getTls()); 
            this.validationEnabled = validationEnabled; 
    }
    public VirtualServiceSpecBuilder(VirtualServiceSpec instance){
            this(instance,true);
    }
    public VirtualServiceSpecBuilder(VirtualServiceSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGateways(instance.getGateways()); 
            this.withHosts(instance.getHosts()); 
            this.withHttp(instance.getHttp()); 
            this.withTcp(instance.getTcp()); 
            this.withTls(instance.getTls()); 
            this.validationEnabled = validationEnabled; 
    }
    public VirtualServiceSpecBuilder(Validator validator){
            this(new VirtualServiceSpec(), true);
    }
    public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent,VirtualServiceSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withGateways(instance.getGateways()); 
            fluent.withHosts(instance.getHosts()); 
            fluent.withHttp(instance.getHttp()); 
            fluent.withTcp(instance.getTcp()); 
            fluent.withTls(instance.getTls()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public VirtualServiceSpecBuilder(VirtualServiceSpec instance,Validator validator){
            this.fluent = this; 
            this.withGateways(instance.getGateways()); 
            this.withHosts(instance.getHosts()); 
            this.withHttp(instance.getHttp()); 
            this.withTcp(instance.getTcp()); 
            this.withTls(instance.getTls()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public VirtualServiceSpec build(){
            VirtualServiceSpec buildable = new VirtualServiceSpec(fluent.getGateways(),fluent.getHosts(),fluent.getHttp(),fluent.getTcp(),fluent.getTls());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            VirtualServiceSpecBuilder that = (VirtualServiceSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
