package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface RbacConfigListFluent<A extends RbacConfigListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,RbacConfig item);
    public A setToItems(int index,RbacConfig item);
    public A addToItems(RbacConfig... items);
    public A addAllToItems(Collection<RbacConfig> items);
    public A removeFromItems(RbacConfig... items);
    public A removeAllFromItems(Collection<RbacConfig> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<RbacConfig> getItems();
    public List<RbacConfig> buildItems();
    public RbacConfig buildItem(int index);
    public RbacConfig buildFirstItem();
    public RbacConfig buildLastItem();
    public RbacConfig buildMatchingItem(Predicate<RbacConfigBuilder> predicate);
    public A withItems(List<RbacConfig> items);
    public A withItems(RbacConfig... items);
    public Boolean hasItems();
    public RbacConfigListFluent.ItemsNested<A> addNewItem();
    public RbacConfigListFluent.ItemsNested<A> addNewItemLike(RbacConfig item);
    public RbacConfigListFluent.ItemsNested<A> setNewItemLike(int index,RbacConfig item);
    public RbacConfigListFluent.ItemsNested<A> editItem(int index);
    public RbacConfigListFluent.ItemsNested<A> editFirstItem();
    public RbacConfigListFluent.ItemsNested<A> editLastItem();
    public RbacConfigListFluent.ItemsNested<A> editMatchingItem(Predicate<RbacConfigBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,RbacConfigFluent<RbacConfigListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
