package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class TargetBuilder extends TargetFluentImpl<TargetBuilder> implements VisitableBuilder<Target,TargetBuilder>{

    TargetFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TargetBuilder(){
            this(true);
    }
    public TargetBuilder(Boolean validationEnabled){
            this(new Target(), validationEnabled);
    }
    public TargetBuilder(TargetFluent<?> fluent){
            this(fluent, true);
    }
    public TargetBuilder(TargetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Target(), validationEnabled);
    }
    public TargetBuilder(TargetFluent<?> fluent,Target instance){
            this(fluent, instance, true);
    }
    public TargetBuilder(TargetFluent<?> fluent,Target instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNamespaces(instance.getNamespaces()); 
            fluent.withServices(instance.getServices()); 
            this.validationEnabled = validationEnabled; 
    }
    public TargetBuilder(Target instance){
            this(instance,true);
    }
    public TargetBuilder(Target instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNamespaces(instance.getNamespaces()); 
            this.withServices(instance.getServices()); 
            this.validationEnabled = validationEnabled; 
    }
    public TargetBuilder(Validator validator){
            this(new Target(), true);
    }
    public TargetBuilder(TargetFluent<?> fluent,Target instance,Validator validator){
            this.fluent = fluent; 
            fluent.withNamespaces(instance.getNamespaces()); 
            fluent.withServices(instance.getServices()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public TargetBuilder(Target instance,Validator validator){
            this.fluent = this; 
            this.withNamespaces(instance.getNamespaces()); 
            this.withServices(instance.getServices()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Target build(){
            Target buildable = new Target(fluent.getNamespaces(),fluent.getServices());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TargetBuilder that = (TargetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
