package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Predicate;

public interface TargetFluent<A extends TargetFluent<A>> extends Fluent<A>{


    public A addToNamespaces(int index,String item);
    public A setToNamespaces(int index,String item);
    public A addToNamespaces(String... items);
    public A addAllToNamespaces(Collection<String> items);
    public A removeFromNamespaces(String... items);
    public A removeAllFromNamespaces(Collection<String> items);
    public List<String> getNamespaces();
    public String getNamespace(int index);
    public String getFirstNamespace();
    public String getLastNamespace();
    public String getMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withNamespaces(List<String> namespaces);
    public A withNamespaces(String... namespaces);
    public Boolean hasNamespaces();
    public A addToServices(int index,String item);
    public A setToServices(int index,String item);
    public A addToServices(String... items);
    public A addAllToServices(Collection<String> items);
    public A removeFromServices(String... items);
    public A removeAllFromServices(Collection<String> items);
    public List<String> getServices();
    public String getService(int index);
    public String getFirstService();
    public String getLastService();
    public String getMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withServices(List<String> services);
    public A withServices(String... services);
    public Boolean hasServices();



}
