
package me.snowdrop.istio.mixer.adapter.kubernetesenv;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "cacheRefreshDuration",
    "kubeconfigPath"
})
@IstioKind(name = "kubernetesenv", plural = "kubernetesenvs")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class KubernetesenvSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("cacheRefreshDuration")
    @JsonPropertyDescription("")
    private Long cacheRefreshDuration;
    /**
     * 
     * 
     */
    @JsonProperty("kubeconfigPath")
    @JsonPropertyDescription("")
    private String kubeconfigPath;
    private final static long serialVersionUID = 4916662521079280032L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubernetesenvSpec() {
    }

    /**
     * 
     * @param cacheRefreshDuration
     * @param kubeconfigPath
     */
    public KubernetesenvSpec(Long cacheRefreshDuration, String kubeconfigPath) {
        super();
        this.cacheRefreshDuration = cacheRefreshDuration;
        this.kubeconfigPath = kubeconfigPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cacheRefreshDuration")
    public Long getCacheRefreshDuration() {
        return cacheRefreshDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cacheRefreshDuration")
    public void setCacheRefreshDuration(Long cacheRefreshDuration) {
        this.cacheRefreshDuration = cacheRefreshDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("kubeconfigPath")
    public String getKubeconfigPath() {
        return kubeconfigPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("kubeconfigPath")
    public void setKubeconfigPath(String kubeconfigPath) {
        this.kubeconfigPath = kubeconfigPath;
    }

}
