package me.snowdrop.istio.mixer.adapter.opa;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface OpaFluent<A extends OpaFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public OpaFluent.MetadataNested<A> withNewMetadata();
    public OpaFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OpaFluent.MetadataNested<A> editMetadata();
    public OpaFluent.MetadataNested<A> editOrNewMetadata();
    public OpaFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public OpaSpec getSpec();
    public OpaSpec buildSpec();
    public A withSpec(OpaSpec spec);
    public Boolean hasSpec();
    public OpaFluent.SpecNested<A> withNewSpec();
    public OpaFluent.SpecNested<A> withNewSpecLike(OpaSpec item);
    public OpaFluent.SpecNested<A> editSpec();
    public OpaFluent.SpecNested<A> editOrNewSpec();
    public OpaFluent.SpecNested<A> editOrNewSpecLike(OpaSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<OpaFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,OpaSpecFluent<OpaFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
