package me.snowdrop.istio.mixer.adapter.prometheus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class MetricsExpirationPolicyFluentImpl<A extends MetricsExpirationPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements MetricsExpirationPolicyFluent<A>{

    private Long expiryCheckIntervalDuration;
    private Long metricsExpiryDuration;

    public MetricsExpirationPolicyFluentImpl(){
    }
    public MetricsExpirationPolicyFluentImpl(MetricsExpirationPolicy instance){
            this.withExpiryCheckIntervalDuration(instance.getExpiryCheckIntervalDuration()); 
            this.withMetricsExpiryDuration(instance.getMetricsExpiryDuration()); 
    }

    public Long getExpiryCheckIntervalDuration(){
            return this.expiryCheckIntervalDuration;
    }

    public A withExpiryCheckIntervalDuration(Long expiryCheckIntervalDuration){
            this.expiryCheckIntervalDuration=expiryCheckIntervalDuration; return (A) this;
    }

    public Boolean hasExpiryCheckIntervalDuration(){
            return this.expiryCheckIntervalDuration != null;
    }

    public A withNewExpiryCheckIntervalDuration(String arg1){
            return (A)withExpiryCheckIntervalDuration(new Long(arg1));
    }

    public A withNewExpiryCheckIntervalDuration(long arg1){
            return (A)withExpiryCheckIntervalDuration(new Long(arg1));
    }

    public Long getMetricsExpiryDuration(){
            return this.metricsExpiryDuration;
    }

    public A withMetricsExpiryDuration(Long metricsExpiryDuration){
            this.metricsExpiryDuration=metricsExpiryDuration; return (A) this;
    }

    public Boolean hasMetricsExpiryDuration(){
            return this.metricsExpiryDuration != null;
    }

    public A withNewMetricsExpiryDuration(String arg1){
            return (A)withMetricsExpiryDuration(new Long(arg1));
    }

    public A withNewMetricsExpiryDuration(long arg1){
            return (A)withMetricsExpiryDuration(new Long(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricsExpirationPolicyFluentImpl that = (MetricsExpirationPolicyFluentImpl) o;
            if (expiryCheckIntervalDuration != null ? !expiryCheckIntervalDuration.equals(that.expiryCheckIntervalDuration) :that.expiryCheckIntervalDuration != null) return false;
            if (metricsExpiryDuration != null ? !metricsExpiryDuration.equals(that.metricsExpiryDuration) :that.metricsExpiryDuration != null) return false;
            return true;
    }




}
