package me.snowdrop.istio.mixer.adapter.redisquota;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class QuotaFluentImpl<A extends me.snowdrop.istio.mixer.adapter.redisquota.QuotaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.mixer.adapter.redisquota.QuotaFluent<A>{

    private Long bucketDuration;
    private Long maxAmount;
    private String name;
    private List<me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder> overrides;
    private QuotaAlgorithm rateLimitAlgorithm;
    private Long validDuration;

    public QuotaFluentImpl(){
    }
    public QuotaFluentImpl(me.snowdrop.istio.mixer.adapter.redisquota.Quota instance){
            this.withBucketDuration(instance.getBucketDuration()); 
            this.withMaxAmount(instance.getMaxAmount()); 
            this.withName(instance.getName()); 
            this.withOverrides(instance.getOverrides()); 
            this.withRateLimitAlgorithm(instance.getRateLimitAlgorithm()); 
            this.withValidDuration(instance.getValidDuration()); 
    }

    public Long getBucketDuration(){
            return this.bucketDuration;
    }

    public A withBucketDuration(Long bucketDuration){
            this.bucketDuration=bucketDuration; return (A) this;
    }

    public Boolean hasBucketDuration(){
            return this.bucketDuration != null;
    }

    public A withNewBucketDuration(String arg1){
            return (A)withBucketDuration(new Long(arg1));
    }

    public A withNewBucketDuration(long arg1){
            return (A)withBucketDuration(new Long(arg1));
    }

    public Long getMaxAmount(){
            return this.maxAmount;
    }

    public A withMaxAmount(Long maxAmount){
            this.maxAmount=maxAmount; return (A) this;
    }

    public Boolean hasMaxAmount(){
            return this.maxAmount != null;
    }

    public A withNewMaxAmount(String arg1){
            return (A)withMaxAmount(new Long(arg1));
    }

    public A withNewMaxAmount(long arg1){
            return (A)withMaxAmount(new Long(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A addToOverrides(int index,me.snowdrop.istio.mixer.adapter.redisquota.Override item){
            if (this.overrides == null) {this.overrides = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder>();}
            me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.overrides.add(index >= 0 ? index : overrides.size(), builder); return (A)this;
    }

    public A setToOverrides(int index,me.snowdrop.istio.mixer.adapter.redisquota.Override item){
            if (this.overrides == null) {this.overrides = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder>();}
            me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= overrides.size()) { overrides.add(builder); } else { overrides.set(index, builder);}
             return (A)this;
    }

    public A addToOverrides(me.snowdrop.istio.mixer.adapter.redisquota.Override... items){
            if (this.overrides == null) {this.overrides = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder>();}
            for (me.snowdrop.istio.mixer.adapter.redisquota.Override item : items) {me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder(item);_visitables.add(builder);this.overrides.add(builder);} return (A)this;
    }

    public A addAllToOverrides(Collection<me.snowdrop.istio.mixer.adapter.redisquota.Override> items){
            if (this.overrides == null) {this.overrides = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder>();}
            for (me.snowdrop.istio.mixer.adapter.redisquota.Override item : items) {me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder(item);_visitables.add(builder);this.overrides.add(builder);} return (A)this;
    }

    public A removeFromOverrides(me.snowdrop.istio.mixer.adapter.redisquota.Override... items){
            for (me.snowdrop.istio.mixer.adapter.redisquota.Override item : items) {me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder(item);_visitables.remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
    }

    public A removeAllFromOverrides(Collection<me.snowdrop.istio.mixer.adapter.redisquota.Override> items){
            for (me.snowdrop.istio.mixer.adapter.redisquota.Override item : items) {me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder(item);_visitables.remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildOverrides instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.mixer.adapter.redisquota.Override> getOverrides(){
            return build(overrides);
    }

    public List<me.snowdrop.istio.mixer.adapter.redisquota.Override> buildOverrides(){
            return build(overrides);
    }

    public me.snowdrop.istio.mixer.adapter.redisquota.Override buildOverride(int index){
            return this.overrides.get(index).build();
    }

    public me.snowdrop.istio.mixer.adapter.redisquota.Override buildFirstOverride(){
            return this.overrides.get(0).build();
    }

    public me.snowdrop.istio.mixer.adapter.redisquota.Override buildLastOverride(){
            return this.overrides.get(overrides.size() - 1).build();
    }

    public me.snowdrop.istio.mixer.adapter.redisquota.Override buildMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder> predicate){
            for (me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder item: overrides) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withOverrides(List<me.snowdrop.istio.mixer.adapter.redisquota.Override> overrides){
            if (this.overrides != null) { _visitables.removeAll(this.overrides);}
            if (overrides != null) {this.overrides = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder>(); for (me.snowdrop.istio.mixer.adapter.redisquota.Override item : overrides){this.addToOverrides(item);}} else { this.overrides = null;} return (A) this;
    }

    public A withOverrides(me.snowdrop.istio.mixer.adapter.redisquota.Override... overrides){
            if (this.overrides != null) {this.overrides.clear();}
            if (overrides != null) {for (me.snowdrop.istio.mixer.adapter.redisquota.Override item :overrides){ this.addToOverrides(item);}} return (A) this;
    }

    public Boolean hasOverrides(){
            return overrides != null && !overrides.isEmpty();
    }

    public QuotaFluent.OverridesNested<A> addNewOverride(){
            return new OverridesNestedImpl();
    }

    public QuotaFluent.OverridesNested<A> addNewOverrideLike(me.snowdrop.istio.mixer.adapter.redisquota.Override item){
            return new OverridesNestedImpl(-1, item);
    }

    public QuotaFluent.OverridesNested<A> setNewOverrideLike(int index,me.snowdrop.istio.mixer.adapter.redisquota.Override item){
            return new OverridesNestedImpl(index, item);
    }

    public QuotaFluent.OverridesNested<A> editOverride(int index){
            if (overrides.size() <= index) throw new RuntimeException("Can't edit overrides. Index exceeds size.");
            return setNewOverrideLike(index, buildOverride(index));
    }

    public QuotaFluent.OverridesNested<A> editFirstOverride(){
            if (overrides.size() == 0) throw new RuntimeException("Can't edit first overrides. The list is empty.");
            return setNewOverrideLike(0, buildOverride(0));
    }

    public QuotaFluent.OverridesNested<A> editLastOverride(){
            int index = overrides.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last overrides. The list is empty.");
            return setNewOverrideLike(index, buildOverride(index));
    }

    public QuotaFluent.OverridesNested<A> editMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder> predicate){
            int index = -1;
            for (int i=0;i<overrides.size();i++) { 
            if (predicate.apply(overrides.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching overrides. No match found.");
            return setNewOverrideLike(index, buildOverride(index));
    }

    public QuotaAlgorithm getRateLimitAlgorithm(){
            return this.rateLimitAlgorithm;
    }

    public A withRateLimitAlgorithm(QuotaAlgorithm rateLimitAlgorithm){
            this.rateLimitAlgorithm=rateLimitAlgorithm; return (A) this;
    }

    public Boolean hasRateLimitAlgorithm(){
            return this.rateLimitAlgorithm != null;
    }

    public Long getValidDuration(){
            return this.validDuration;
    }

    public A withValidDuration(Long validDuration){
            this.validDuration=validDuration; return (A) this;
    }

    public Boolean hasValidDuration(){
            return this.validDuration != null;
    }

    public A withNewValidDuration(String arg1){
            return (A)withValidDuration(new Long(arg1));
    }

    public A withNewValidDuration(long arg1){
            return (A)withValidDuration(new Long(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaFluentImpl that = (QuotaFluentImpl) o;
            if (bucketDuration != null ? !bucketDuration.equals(that.bucketDuration) :that.bucketDuration != null) return false;
            if (maxAmount != null ? !maxAmount.equals(that.maxAmount) :that.maxAmount != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (overrides != null ? !overrides.equals(that.overrides) :that.overrides != null) return false;
            if (rateLimitAlgorithm != null ? !rateLimitAlgorithm.equals(that.rateLimitAlgorithm) :that.rateLimitAlgorithm != null) return false;
            if (validDuration != null ? !validDuration.equals(that.validDuration) :that.validDuration != null) return false;
            return true;
    }


    public class OverridesNestedImpl<N> extends me.snowdrop.istio.mixer.adapter.redisquota.OverrideFluentImpl<QuotaFluent.OverridesNested<N>> implements QuotaFluent.OverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder builder;
        private final int index;
    
            OverridesNestedImpl(int index,me.snowdrop.istio.mixer.adapter.redisquota.Override item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder(this, item);
            }
            OverridesNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.mixer.adapter.redisquota.OverrideBuilder(this);
            }
    
    public N and(){
            return (N) QuotaFluentImpl.this.setToOverrides(index, builder.build());
    }
    public N endOverride(){
            return and();
    }

}


}
