package me.snowdrop.istio.mixer.adapter.redisquota;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RedisquotaSpecFluentImpl<A extends RedisquotaSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RedisquotaSpecFluent<A>{

    private Long connectionPoolSize;
    private List<me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder> quotas;
    private String redisServerUrl;

    public RedisquotaSpecFluentImpl(){
    }
    public RedisquotaSpecFluentImpl(RedisquotaSpec instance){
            this.withConnectionPoolSize(instance.getConnectionPoolSize()); 
            this.withQuotas(instance.getQuotas()); 
            this.withRedisServerUrl(instance.getRedisServerUrl()); 
    }

    public Long getConnectionPoolSize(){
            return this.connectionPoolSize;
    }

    public A withConnectionPoolSize(Long connectionPoolSize){
            this.connectionPoolSize=connectionPoolSize; return (A) this;
    }

    public Boolean hasConnectionPoolSize(){
            return this.connectionPoolSize != null;
    }

    public A withNewConnectionPoolSize(String arg1){
            return (A)withConnectionPoolSize(new Long(arg1));
    }

    public A withNewConnectionPoolSize(long arg1){
            return (A)withConnectionPoolSize(new Long(arg1));
    }

    public A addToQuotas(int index,me.snowdrop.istio.mixer.adapter.redisquota.Quota item){
            if (this.quotas == null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder>();}
            me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.quotas.add(index >= 0 ? index : quotas.size(), builder); return (A)this;
    }

    public A setToQuotas(int index,me.snowdrop.istio.mixer.adapter.redisquota.Quota item){
            if (this.quotas == null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder>();}
            me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= quotas.size()) { quotas.add(builder); } else { quotas.set(index, builder);}
             return (A)this;
    }

    public A addToQuotas(me.snowdrop.istio.mixer.adapter.redisquota.Quota... items){
            if (this.quotas == null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder>();}
            for (me.snowdrop.istio.mixer.adapter.redisquota.Quota item : items) {me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder(item);_visitables.add(builder);this.quotas.add(builder);} return (A)this;
    }

    public A addAllToQuotas(Collection<me.snowdrop.istio.mixer.adapter.redisquota.Quota> items){
            if (this.quotas == null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder>();}
            for (me.snowdrop.istio.mixer.adapter.redisquota.Quota item : items) {me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder(item);_visitables.add(builder);this.quotas.add(builder);} return (A)this;
    }

    public A removeFromQuotas(me.snowdrop.istio.mixer.adapter.redisquota.Quota... items){
            for (me.snowdrop.istio.mixer.adapter.redisquota.Quota item : items) {me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder(item);_visitables.remove(builder);if (this.quotas != null) {this.quotas.remove(builder);}} return (A)this;
    }

    public A removeAllFromQuotas(Collection<me.snowdrop.istio.mixer.adapter.redisquota.Quota> items){
            for (me.snowdrop.istio.mixer.adapter.redisquota.Quota item : items) {me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder(item);_visitables.remove(builder);if (this.quotas != null) {this.quotas.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildQuotas instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.mixer.adapter.redisquota.Quota> getQuotas(){
            return build(quotas);
    }

    public List<me.snowdrop.istio.mixer.adapter.redisquota.Quota> buildQuotas(){
            return build(quotas);
    }

    public me.snowdrop.istio.mixer.adapter.redisquota.Quota buildQuota(int index){
            return this.quotas.get(index).build();
    }

    public me.snowdrop.istio.mixer.adapter.redisquota.Quota buildFirstQuota(){
            return this.quotas.get(0).build();
    }

    public me.snowdrop.istio.mixer.adapter.redisquota.Quota buildLastQuota(){
            return this.quotas.get(quotas.size() - 1).build();
    }

    public me.snowdrop.istio.mixer.adapter.redisquota.Quota buildMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder> predicate){
            for (me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder item: quotas) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withQuotas(List<me.snowdrop.istio.mixer.adapter.redisquota.Quota> quotas){
            if (this.quotas != null) { _visitables.removeAll(this.quotas);}
            if (quotas != null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder>(); for (me.snowdrop.istio.mixer.adapter.redisquota.Quota item : quotas){this.addToQuotas(item);}} else { this.quotas = null;} return (A) this;
    }

    public A withQuotas(me.snowdrop.istio.mixer.adapter.redisquota.Quota... quotas){
            if (this.quotas != null) {this.quotas.clear();}
            if (quotas != null) {for (me.snowdrop.istio.mixer.adapter.redisquota.Quota item :quotas){ this.addToQuotas(item);}} return (A) this;
    }

    public Boolean hasQuotas(){
            return quotas != null && !quotas.isEmpty();
    }

    public RedisquotaSpecFluent.QuotasNested<A> addNewQuota(){
            return new QuotasNestedImpl();
    }

    public RedisquotaSpecFluent.QuotasNested<A> addNewQuotaLike(me.snowdrop.istio.mixer.adapter.redisquota.Quota item){
            return new QuotasNestedImpl(-1, item);
    }

    public RedisquotaSpecFluent.QuotasNested<A> setNewQuotaLike(int index,me.snowdrop.istio.mixer.adapter.redisquota.Quota item){
            return new QuotasNestedImpl(index, item);
    }

    public RedisquotaSpecFluent.QuotasNested<A> editQuota(int index){
            if (quotas.size() <= index) throw new RuntimeException("Can't edit quotas. Index exceeds size.");
            return setNewQuotaLike(index, buildQuota(index));
    }

    public RedisquotaSpecFluent.QuotasNested<A> editFirstQuota(){
            if (quotas.size() == 0) throw new RuntimeException("Can't edit first quotas. The list is empty.");
            return setNewQuotaLike(0, buildQuota(0));
    }

    public RedisquotaSpecFluent.QuotasNested<A> editLastQuota(){
            int index = quotas.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last quotas. The list is empty.");
            return setNewQuotaLike(index, buildQuota(index));
    }

    public RedisquotaSpecFluent.QuotasNested<A> editMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder> predicate){
            int index = -1;
            for (int i=0;i<quotas.size();i++) { 
            if (predicate.apply(quotas.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching quotas. No match found.");
            return setNewQuotaLike(index, buildQuota(index));
    }

    public String getRedisServerUrl(){
            return this.redisServerUrl;
    }

    public A withRedisServerUrl(String redisServerUrl){
            this.redisServerUrl=redisServerUrl; return (A) this;
    }

    public Boolean hasRedisServerUrl(){
            return this.redisServerUrl != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RedisquotaSpecFluentImpl that = (RedisquotaSpecFluentImpl) o;
            if (connectionPoolSize != null ? !connectionPoolSize.equals(that.connectionPoolSize) :that.connectionPoolSize != null) return false;
            if (quotas != null ? !quotas.equals(that.quotas) :that.quotas != null) return false;
            if (redisServerUrl != null ? !redisServerUrl.equals(that.redisServerUrl) :that.redisServerUrl != null) return false;
            return true;
    }


    public class QuotasNestedImpl<N> extends me.snowdrop.istio.mixer.adapter.redisquota.QuotaFluentImpl<RedisquotaSpecFluent.QuotasNested<N>> implements RedisquotaSpecFluent.QuotasNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder builder;
        private final int index;
    
            QuotasNestedImpl(int index,me.snowdrop.istio.mixer.adapter.redisquota.Quota item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder(this, item);
            }
            QuotasNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.mixer.adapter.redisquota.QuotaBuilder(this);
            }
    
    public N and(){
            return (N) RedisquotaSpecFluentImpl.this.setToQuotas(index, builder.build());
    }
    public N endQuota(){
            return and();
    }

}


}
