
package me.snowdrop.istio.mixer.adapter.servicecontrol;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "checkCacheSize",
    "checkResultExpiration"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class RuntimeConfig implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("checkCacheSize")
    @JsonPropertyDescription("")
    private Integer checkCacheSize;
    /**
     * 
     * 
     */
    @JsonProperty("checkResultExpiration")
    @JsonPropertyDescription("")
    @Valid
    private Duration checkResultExpiration;
    private final static long serialVersionUID = -4343379017618141653L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RuntimeConfig() {
    }

    /**
     * 
     * @param checkCacheSize
     * @param checkResultExpiration
     */
    public RuntimeConfig(Integer checkCacheSize, Duration checkResultExpiration) {
        super();
        this.checkCacheSize = checkCacheSize;
        this.checkResultExpiration = checkResultExpiration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("checkCacheSize")
    public Integer getCheckCacheSize() {
        return checkCacheSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("checkCacheSize")
    public void setCheckCacheSize(Integer checkCacheSize) {
        this.checkCacheSize = checkCacheSize;
    }

    /**
     * 
     * 
     */
    @JsonProperty("checkResultExpiration")
    public Duration getCheckResultExpiration() {
        return checkResultExpiration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("checkResultExpiration")
    public void setCheckResultExpiration(Duration checkResultExpiration) {
        this.checkResultExpiration = checkResultExpiration;
    }

}
