package me.snowdrop.istio.mixer.adapter.servicecontrol;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import me.snowdrop.istio.api.DurationFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.api.Duration;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.DurationBuilder;

public interface RuntimeConfigFluent<A extends RuntimeConfigFluent<A>> extends Fluent<A>{


    public Integer getCheckCacheSize();
    public A withCheckCacheSize(Integer checkCacheSize);
    public Boolean hasCheckCacheSize();
    public A withNewCheckCacheSize(String arg1);
    public A withNewCheckCacheSize(int arg1);
    
/**
 * This method has been deprecated, please use method buildCheckResultExpiration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getCheckResultExpiration();
    public Duration buildCheckResultExpiration();
    public A withCheckResultExpiration(Duration checkResultExpiration);
    public Boolean hasCheckResultExpiration();
    public A withNewCheckResultExpiration(Integer nanos,Long seconds);
    public RuntimeConfigFluent.CheckResultExpirationNested<A> withNewCheckResultExpiration();
    public RuntimeConfigFluent.CheckResultExpirationNested<A> withNewCheckResultExpirationLike(Duration item);
    public RuntimeConfigFluent.CheckResultExpirationNested<A> editCheckResultExpiration();
    public RuntimeConfigFluent.CheckResultExpirationNested<A> editOrNewCheckResultExpiration();
    public RuntimeConfigFluent.CheckResultExpirationNested<A> editOrNewCheckResultExpirationLike(Duration item);

    public interface CheckResultExpirationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DurationFluent<RuntimeConfigFluent.CheckResultExpirationNested<N>>{

        
    public N and();    public N endCheckResultExpiration();
}


}
