package me.snowdrop.istio.mixer.adapter.servicecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ServicecontrolBuilder extends ServicecontrolFluentImpl<ServicecontrolBuilder> implements VisitableBuilder<Servicecontrol,ServicecontrolBuilder>{

    ServicecontrolFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServicecontrolBuilder(){
            this(true);
    }
    public ServicecontrolBuilder(Boolean validationEnabled){
            this(new Servicecontrol(), validationEnabled);
    }
    public ServicecontrolBuilder(ServicecontrolFluent<?> fluent){
            this(fluent, true);
    }
    public ServicecontrolBuilder(ServicecontrolFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Servicecontrol(), validationEnabled);
    }
    public ServicecontrolBuilder(ServicecontrolFluent<?> fluent,Servicecontrol instance){
            this(fluent, instance, true);
    }
    public ServicecontrolBuilder(ServicecontrolFluent<?> fluent,Servicecontrol instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServicecontrolBuilder(Servicecontrol instance){
            this(instance,true);
    }
    public ServicecontrolBuilder(Servicecontrol instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServicecontrolBuilder(Validator validator){
            this(new Servicecontrol(), true);
    }
    public ServicecontrolBuilder(ServicecontrolFluent<?> fluent,Servicecontrol instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ServicecontrolBuilder(Servicecontrol instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Servicecontrol build(){
            Servicecontrol buildable = new Servicecontrol(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServicecontrolBuilder that = (ServicecontrolBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
