package me.snowdrop.istio.mixer.adapter.servicecontrol;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface ServicecontrolFluent<A extends ServicecontrolFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ServicecontrolFluent.MetadataNested<A> withNewMetadata();
    public ServicecontrolFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServicecontrolFluent.MetadataNested<A> editMetadata();
    public ServicecontrolFluent.MetadataNested<A> editOrNewMetadata();
    public ServicecontrolFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ServicecontrolSpec getSpec();
    public ServicecontrolSpec buildSpec();
    public A withSpec(ServicecontrolSpec spec);
    public Boolean hasSpec();
    public ServicecontrolFluent.SpecNested<A> withNewSpec();
    public ServicecontrolFluent.SpecNested<A> withNewSpecLike(ServicecontrolSpec item);
    public ServicecontrolFluent.SpecNested<A> editSpec();
    public ServicecontrolFluent.SpecNested<A> editOrNewSpec();
    public ServicecontrolFluent.SpecNested<A> editOrNewSpecLike(ServicecontrolSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServicecontrolFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ServicecontrolSpecFluent<ServicecontrolFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
