
package me.snowdrop.istio.mixer.adapter.servicecontrol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "credentialPath",
    "runtimeConfig",
    "serviceConfigs"
})
@IstioKind(name = "servicecontrol", plural = "servicecontrols")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class ServicecontrolSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("credentialPath")
    @JsonPropertyDescription("")
    private String credentialPath;
    /**
     * 
     * 
     */
    @JsonProperty("runtimeConfig")
    @JsonPropertyDescription("")
    @Valid
    private RuntimeConfig runtimeConfig;
    /**
     * 
     * 
     */
    @JsonProperty("serviceConfigs")
    @JsonPropertyDescription("")
    @Valid
    private List<GcpServiceSetting> serviceConfigs = new ArrayList<GcpServiceSetting>();
    private final static long serialVersionUID = 3236146673712938775L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServicecontrolSpec() {
    }

    /**
     * 
     * @param credentialPath
     * @param serviceConfigs
     * @param runtimeConfig
     */
    public ServicecontrolSpec(String credentialPath, RuntimeConfig runtimeConfig, List<GcpServiceSetting> serviceConfigs) {
        super();
        this.credentialPath = credentialPath;
        this.runtimeConfig = runtimeConfig;
        this.serviceConfigs = serviceConfigs;
    }

    /**
     * 
     * 
     */
    @JsonProperty("credentialPath")
    public String getCredentialPath() {
        return credentialPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("credentialPath")
    public void setCredentialPath(String credentialPath) {
        this.credentialPath = credentialPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("runtimeConfig")
    public RuntimeConfig getRuntimeConfig() {
        return runtimeConfig;
    }

    /**
     * 
     * 
     */
    @JsonProperty("runtimeConfig")
    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    /**
     * 
     * 
     */
    @JsonProperty("serviceConfigs")
    public List<GcpServiceSetting> getServiceConfigs() {
        return serviceConfigs;
    }

    /**
     * 
     * 
     */
    @JsonProperty("serviceConfigs")
    public void setServiceConfigs(List<GcpServiceSetting> serviceConfigs) {
        this.serviceConfigs = serviceConfigs;
    }

}
