package me.snowdrop.istio.mixer.adapter.signalfx;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SignalfxBuilder extends SignalfxFluentImpl<SignalfxBuilder> implements VisitableBuilder<Signalfx,SignalfxBuilder>{

    SignalfxFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SignalfxBuilder(){
            this(true);
    }
    public SignalfxBuilder(Boolean validationEnabled){
            this(new Signalfx(), validationEnabled);
    }
    public SignalfxBuilder(SignalfxFluent<?> fluent){
            this(fluent, true);
    }
    public SignalfxBuilder(SignalfxFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Signalfx(), validationEnabled);
    }
    public SignalfxBuilder(SignalfxFluent<?> fluent,Signalfx instance){
            this(fluent, instance, true);
    }
    public SignalfxBuilder(SignalfxFluent<?> fluent,Signalfx instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public SignalfxBuilder(Signalfx instance){
            this(instance,true);
    }
    public SignalfxBuilder(Signalfx instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public SignalfxBuilder(Validator validator){
            this(new Signalfx(), true);
    }
    public SignalfxBuilder(SignalfxFluent<?> fluent,Signalfx instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SignalfxBuilder(Signalfx instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Signalfx build(){
            Signalfx buildable = new Signalfx(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SignalfxBuilder that = (SignalfxBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
