package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ApiKeyCredsBuilder extends ApiKeyCredsFluentImpl<ApiKeyCredsBuilder> implements VisitableBuilder<ApiKeyCreds,ApiKeyCredsBuilder>{

    ApiKeyCredsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ApiKeyCredsBuilder(){
            this(true);
    }
    public ApiKeyCredsBuilder(Boolean validationEnabled){
            this(new ApiKeyCreds(), validationEnabled);
    }
    public ApiKeyCredsBuilder(ApiKeyCredsFluent<?> fluent){
            this(fluent, true);
    }
    public ApiKeyCredsBuilder(ApiKeyCredsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ApiKeyCreds(), validationEnabled);
    }
    public ApiKeyCredsBuilder(ApiKeyCredsFluent<?> fluent,ApiKeyCreds instance){
            this(fluent, instance, true);
    }
    public ApiKeyCredsBuilder(ApiKeyCredsFluent<?> fluent,ApiKeyCreds instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiKey(instance.getApiKey()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiKeyCredsBuilder(ApiKeyCreds instance){
            this(instance,true);
    }
    public ApiKeyCredsBuilder(ApiKeyCreds instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiKey(instance.getApiKey()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiKeyCredsBuilder(Validator validator){
            this(new ApiKeyCreds(), true);
    }
    public ApiKeyCredsBuilder(ApiKeyCredsFluent<?> fluent,ApiKeyCreds instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiKey(instance.getApiKey()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ApiKeyCredsBuilder(ApiKeyCreds instance,Validator validator){
            this.fluent = this; 
            this.withApiKey(instance.getApiKey()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ApiKeyCreds build(){
            ApiKeyCreds buildable = new ApiKeyCreds(fluent.getApiKey());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ApiKeyCredsBuilder that = (ApiKeyCredsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
